package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2181;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.GroundSearchArgumentType;
import dev.amble.ait.core.util.SafePosSearch;

public class SafePosCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
                method_9247(AITMod.MOD_ID).then(method_9247("safe-pos").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.safe-pos", 2))
                        .then(method_9244("world", class_2181.method_9288())
                                .then(method_9244("pos", class_2262.method_9698())
                                        .then(method_9244("search-type", GroundSearchArgumentType.groundSearch())
                                                .executes(SafePosCommand::execute))))));
    }

    public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = class_2181.method_9289(context, "world");
        class_2338 posA = class_2262.method_48299(context, "pos");

        SafePosSearch.Kind search = GroundSearchArgumentType.getGroundSearch(context, "search-type");
        CachedDirectedGlobalPos pos = CachedDirectedGlobalPos.create(world, posA, (byte) 0);

        SafePosSearch.wrapSafe(pos, search, false,
                result -> reply(context, result.getPos()));

        return Command.SINGLE_SUCCESS;
    }

    private static void reply(CommandContext<class_2168> context, class_2338 blockPos) {
        class_2561 text = class_2564
                .method_10885(class_2561.method_43469("chat.coordinates", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()))
                .method_27694((style) -> style.method_10977(class_124.field_1060)
                        .method_10958(new class_2558(class_2558.class_2559.field_11745,
                                "/tp @s " + blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260()))
                        .method_10949(new class_2568(class_2568.class_5247.field_24342,
                                class_2561.method_43471("chat.coordinates.tooltip"))));

        context.getSource().method_45068(text);
    }
}
