package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class ScaleCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("scale").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.scale", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis()).then(method_9244("x", DoubleArgumentType.doubleArg()))
                        .then(method_9244("y", DoubleArgumentType.doubleArg()))
                        .then(method_9244("z", DoubleArgumentType.doubleArg())).executes(ScaleCommand::runCommand))));
    }

    private static int runCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        if (tardis == null) {
            context.getSource().method_9213(class_2561.method_30163("Tardis not found."));
            return 0;
        }
        double x = DoubleArgumentType.getDouble(context, "x");
        double y = DoubleArgumentType.getDouble(context, "y");
        double z = DoubleArgumentType.getDouble(context, "z");

        StatsHandler stats = tardis.stats();
        stats.setScale(x, y, z);

        return Command.SINGLE_SUCCESS;
    }
}
