package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import net.minecraft.class_2168;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class SetDoorParticleCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("door_particle").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.door_particle", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis()).then(method_9244("particle_type", class_2223.method_9417(access)).executes(SetDoorParticleCommand::execute)))));
    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        class_2394 particle = class_2223.method_9421(context, "particle_type");

        tardis.door().setDoorParticles(particle);

        source.method_9226(
                () -> class_2561.method_48322("command.ait.door_particle.done", "Particle of [%s] set to [%s]", tardis.getUuid(), particle.method_10293()),
                true);

        return Command.SINGLE_SUCCESS;
    }
}
