package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class SetLockedCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("lock").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.lock", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis())
                        .then(method_9244("locked", BoolArgumentType.bool()).executes(SetLockedCommand::runCommand)))));
    }

    private static int runCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 source = context.getSource().method_44023();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        boolean locked = BoolArgumentType.getBool(context, "locked");

        tardis.door().interactLock(locked, source, true);
        return Command.SINGLE_SUCCESS;
    }
}
