package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import net.minecraft.class_2168;

/**
 * temporary command to set max speed until we find a proper way
 */
public class SetMaxSpeedCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("set-max-speed")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.set-max-speed", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis()).then(
                        method_9244("speed", IntegerArgumentType.integer(0)).executes(SetMaxSpeedCommand::runCommand)))));
    }

    private static int runCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        int speed = IntegerArgumentType.getInteger(context, "speed");

        tardis.travel().maxSpeed().set(speed);
        return Command.SINGLE_SUCCESS;
    }
}
