package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class SetRepairTicksCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID)
                .then(method_9247("repair").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.repair", 2))
                        .then(method_9247("set").then(method_9244("tardis", TardisArgumentType.tardis()).then(
                                method_9244("ticks", IntegerArgumentType.integer(0, TardisCrashHandler.MAX_REPAIR_TICKS))
                                        .executes(SetRepairTicksCommand::runCommand))))));
    }

    private static int runCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        if (tardis.crash().getRepairTicks() >= TardisCrashHandler.MAX_REPAIR_TICKS) {
            source.method_45068(class_2561.method_48321("tardis.repair.max", "TARDIS repair ticks are at max!"));
            return 0;
        }

        int repairTicksAmount = IntegerArgumentType.getInteger(context, "ticks");
        tardis.crash().setRepairTicks(repairTicksAmount);

        source.method_45068(class_2561.method_48322("tardis.repair.set", "Set repair ticks for [%s] to: [%s]",
                tardis.getUuid(), tardis.crash().getRepairTicks()));

        return Command.SINGLE_SUCCESS;
    }
}
