package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.util.TardisUtil;

public final class TeleportInteriorCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("teleport").requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.teleport", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis())
                                .then(method_9247("interior").executes(TeleportInteriorCommand::tpSelfInterior)
                                        .then(method_9244("entities", class_2186.method_9308())
                                                .executes(TeleportInteriorCommand::tpToInterior)))
                                .then(method_9247("exterior").executes(TeleportInteriorCommand::tpSelfExterior)
                                        .then(method_9244("entities", class_2186.method_9308())
                                                .executes(TeleportInteriorCommand::tpToExterior)))
                )));
    }

    private static int tpSelfInterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 source = context.getSource().method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        return tpToInterior(tardis, Collections.singleton(source));
    }

    private static int tpSelfExterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 source = context.getSource().method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        return tpToExterior(tardis, Collections.singleton(source));
    }

    private static int tpToInterior(CommandContext<class_2168> context)
            throws CommandSyntaxException {
        class_1297 source = context.getSource().method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Collection<? extends class_1297> entities = class_2186.method_9317(context, "entities");

        return tpToInterior(tardis, source, entities);
    }

    private static int tpToExterior(CommandContext<class_2168> context)
            throws CommandSyntaxException {
        class_1297 source = context.getSource().method_9228();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");
        Collection<? extends class_1297> entities = class_2186.method_9317(context, "entities");

        return tpToExterior(tardis, source, entities);
    }

    private static int tpToInterior(ServerTardis tardis, class_1297 source, Collection<? extends class_1297> players) {
        for (class_1297 player : players) {
            TardisUtil.teleportInside(tardis, player);
        }

        source.method_43496(class_2561.method_48321("tardis.teleport.interior.success",
                "Successful teleport - interior of [" + tardis.getUuid().toString().substring(0, 7) + "]"));

        return Command.SINGLE_SUCCESS;
    }

    private static int tpToExterior(ServerTardis tardis, class_1297 source, Collection<? extends class_1297> players) {
        for (class_1297 player : players) {
            TardisUtil.teleportOutside(tardis, player);
        }

        source.method_43496(class_2561.method_48321("tardis.teleport.exterior.success",
                "Successful teleport - exterior of [" + tardis.getUuid().toString().substring(0, 7) + "]"));

        return Command.SINGLE_SUCCESS;
    }

    private static int tpToInterior(ServerTardis tardis, Collection<? extends class_1297> players) {
        if (players.isEmpty())
            return 0;

        return tpToInterior(tardis, players.stream().findFirst().get(), players);
    }

    private static int tpToExterior(ServerTardis tardis, Collection<? extends class_1297> players) {
        if (players.isEmpty())
            return 0;

        return tpToExterior(tardis, players.stream().findFirst().get(), players);
    }
}
