package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9247;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.util.TextUtil;
import dev.amble.ait.core.world.TardisServerWorld;

public class ThisTardisCommand {

    // TODO: add BlockPosition argument type
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("this")
                .executes(ThisTardisCommand::runCommand)));
    }

    private static int runCommand(CommandContext<class_2168> context) {
        if (context.getSource().method_9225() instanceof TardisServerWorld tardisWorld) {
            context.getSource().method_45068(class_2561.method_43471("message.ait.id").method_10852(TextUtil.forTardis(tardisWorld.getTardis())));
        } else if (context.getSource().method_43737()) {
            class_3222 player = context.getSource().method_44023();
            class_1799 stack = player.method_6047();

            try {
                UUID id = LinkableItem.getTardisIdStatic(stack);

                if (id == null || id.toString().isEmpty()) {
                    // Since an IllegalArgumentException is automatically thrown when the held item is not linkable,
                    // we want to show the same error message when a held linkable item is not linked.
                    throw new IllegalArgumentException();
                } else
                    player.method_43496(class_2561.method_43471("message.ait.id").method_10852(TextUtil.forTardis(id)));
            } catch (IllegalArgumentException ignored) {
                player.method_43496(class_2561.method_43471("command.ait.this.not_found"));
            }
        }

        return Command.SINGLE_SUCCESS;
    }
}
