package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.Tardis;
import net.minecraft.class_2168;
import net.minecraft.class_2181;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class TravelDebugCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("travel")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.travel", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis())
                        .then(method_9247("demat").executes(TravelDebugCommand::demat))
                        .then(method_9247("destination").then(method_9244("dimension", class_2181.method_9288()).then(
                                method_9244("pos", class_2262.method_9698()).executes(TravelDebugCommand::setPos))))
                        .then(method_9247("remat").executes(TravelDebugCommand::remat)))));
    }

    private static int demat(CommandContext<class_2168> context) throws CommandSyntaxException {
        Tardis tardis = TardisArgumentType.getTardis(context, "tardis");
        tardis.travel().dematerialize();

        return Command.SINGLE_SUCCESS;
    }

    private static int setPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        Tardis tardis = TardisArgumentType.getTardis(context, "tardis");
        class_3218 world = class_2181.method_9289(context, "dimension");
        class_2338 pos = class_2262.method_48299(context, "pos");

        tardis.travel().forceDestination(cached -> cached.world(world).pos(pos));
        return Command.SINGLE_SUCCESS;
    }

    private static int remat(CommandContext<class_2168> context) throws CommandSyntaxException {
        Tardis tardis = TardisArgumentType.getTardis(context, "tardis");
        tardis.travel().rematerialize();

        return Command.SINGLE_SUCCESS;
    }
}
