package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.mood.MoodHandler;
import net.minecraft.class_2168;

public class TriggerMoodRollCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("trigger-mood-roll")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.trigger-mood-roll", 2)).then(method_9244("tardis", TardisArgumentType.tardis())
                        .executes(TriggerMoodRollCommand::triggerMoodRollCommand))));
    }

    private static int triggerMoodRollCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        tardis.<MoodHandler>handler(TardisComponent.Id.MOOD).rollForMoodDictatedEvent();

        return Command.SINGLE_SUCCESS;
    }
}
