package dev.amble.ait.core.commands;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.register.unlockable.Unlockable;
import dev.amble.lib.register.unlockable.UnlockableRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.compat.permissionapi.PermissionAPICompat;
import dev.amble.ait.core.commands.argument.IdentifierWildcardArgumentType;
import dev.amble.ait.core.commands.argument.TardisArgumentType;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.data.Wildcard;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

public class UnlockCommand {

    public static final SuggestionProvider<class_2168> CONSOLE_SUGGESTION = (context,
            builder) -> IdentifierWildcardArgumentType.suggestWildcardIds(builder,
                    ConsoleVariantRegistry.getInstance());
    public static final SuggestionProvider<class_2168> DESKTOP_SUGGESTION = (context,
            builder) -> IdentifierWildcardArgumentType.suggestWildcardIds(builder, DesktopRegistry.getInstance());
    public static final SuggestionProvider<class_2168> EXTERIOR_SUGGESTION = (context,
            builder) -> IdentifierWildcardArgumentType.suggestWildcardIds(builder,
                    ExteriorVariantRegistry.getInstance());

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247(AITMod.MOD_ID).then(method_9247("unlock")
                .requires(source -> PermissionAPICompat.hasPermission(source, "ait.command.unlock", 2))
                .then(method_9244("tardis", TardisArgumentType.tardis())
                        .then(method_9247("console").then(method_9244("console", IdentifierWildcardArgumentType.wildcard())
                                .suggests(CONSOLE_SUGGESTION).executes(UnlockCommand::unlockConsole)))
                        .then(method_9247("desktop").then(method_9244("desktop", IdentifierWildcardArgumentType.wildcard())
                                .suggests(DESKTOP_SUGGESTION).executes(UnlockCommand::unlockDesktop)))
                        .then(method_9247("exterior").then(method_9244("exterior", IdentifierWildcardArgumentType.wildcard())
                                .suggests(EXTERIOR_SUGGESTION).executes(UnlockCommand::unlockExterior))))));
    }

    private static <T extends Identifiable & Unlockable & Nameable> int unlock(
            CommandContext<class_2168> context, String type, Wildcard<T> wildcard,
            UnlockableRegistry<T> registry) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        ServerTardis tardis = TardisArgumentType.getTardis(context, "tardis");

        if (wildcard.isPresent()) {
            T t = wildcard.get();
            source.method_9211().execute(() -> tardis.stats().unlock(t));

            source.method_45068(class_2561.method_48322("command.ait.unlock.some", "Granted [%s] %s %s",
                    tardis.getUuid(), t.name(), type));

            return Command.SINGLE_SUCCESS;
        }

        source.method_9211().execute(() -> registry.unlockAll(tardis));
        source.method_45068(class_2561.method_48322("command.ait.unlock.all", "Granted [%s] every %s",
                tardis.getUuid(), type));

        return Command.SINGLE_SUCCESS;
    }

    private static int unlockConsole(CommandContext<class_2168> context) throws CommandSyntaxException {
        return unlock(context, "console", IdentifierWildcardArgumentType.getConsoleVariantArgument(context, "console"),
                ConsoleVariantRegistry.getInstance());
    }

    private static int unlockDesktop(CommandContext<class_2168> context) throws CommandSyntaxException {
        return unlock(context, "desktop", IdentifierWildcardArgumentType.getDesktopArgument(context, "desktop"),
                DesktopRegistry.getInstance());
    }

    private static int unlockExterior(CommandContext<class_2168> context) throws CommandSyntaxException {
        return unlock(context, "exterior variant",
                IdentifierWildcardArgumentType.getExteriorVariantArgument(context, "exterior"),
                ExteriorVariantRegistry.getInstance());
    }
}
