package dev.amble.ait.core.commands.argument;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3965;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.world.TardisServerWorld;

public class TardisArgumentType implements ArgumentType<TardisArgumentType.ServerTardisAccessor> {

    public static final SimpleCommandExceptionType INVALID_UUID = new SimpleCommandExceptionType(
            class_2561.method_43471("argument.uuid.invalid"));

    private static final Collection<String> EXAMPLES = List.of("~", "^", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    private static final Pattern VALID_CHARACTERS = Pattern.compile("^([-A-Fa-f0-9]+)");

    public static ServerTardis getTardis(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        return context.getArgument(name, ServerTardisAccessor.class).get(context);
    }

    public static TardisArgumentType tardis() {
        return new TardisArgumentType();
    }

    @Override
    public ServerTardisAccessor parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '~') {
            reader.skip();

            return context -> {
                if (!(context.getSource().method_9225() instanceof TardisServerWorld tardisWorld))
                    throw INVALID_UUID.create();

                return tardisWorld.getTardis();
            };
        }

        if (reader.canRead() && reader.peek() == '^') {
            reader.skip();

            return context -> {
                class_239 hit = context.getSource().method_9228().method_5745(16, 0, false);

                if (!(hit instanceof class_3965 blockHit))
                    throw INVALID_UUID.create();

                class_2586 blockEntity = context.getSource().method_9225().method_8321(blockHit.method_17777());

                if (!(blockEntity instanceof AbstractLinkableBlockEntity linkable))
                    throw INVALID_UUID.create();

                return linkable.tardis().get().asServer();
            };
        }

        String string = reader.getRemaining();

        Matcher matcher = VALID_CHARACTERS.matcher(string);

        if (!matcher.find())
            throw INVALID_UUID.create();

        String raw = matcher.group(1);

        UUID uuid = UUID.fromString(raw);
        reader.setCursor(reader.getCursor() + raw.length());

        return context -> ServerTardisManager.getInstance().demandTardis(context.getSource().method_9211(), uuid);
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        boolean isServer = context.getSource() instanceof class_2168;
        TardisManager<?, ?> manager = TardisManager.getInstance(isServer);

        return class_2172.method_9264(manager.ids().stream().map(UUID::toString),
                builder.suggest("~").suggest("^"));
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public interface ServerTardisAccessor {
        ServerTardis get(CommandContext<class_2168> context) throws CommandSyntaxException;
    }
}
