package dev.amble.ait.core.engine.block;

import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.link.block.FluidLinkBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public abstract class SubSystemBlock extends FluidLinkBlock {
    private final SubSystem.IdLike id;

    protected SubSystemBlock(class_2251 settings, SubSystem.IdLike system) {
        super(settings);

        this.id = system;
    }

    public SubSystem.IdLike getSystemId() {
        return this.id;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204() && !(world.method_8608())) {
            class_2586 blockEntity = world.method_8321(pos);

            if (blockEntity instanceof SubSystemBlockEntity be)
                world.method_8455(pos, this);
        }

        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof SubSystemBlockEntity be) {
                be.tick(world1, pos, state1);
            }
        };
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand,
                              class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        class_1799 stack = player.method_5998(hand);
        if (blockEntity instanceof SubSystemBlockEntity be)
            return be.useOn(state, world, player.method_5715(), player, stack);

        return class_1269.field_5812;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);

        if (!(world.method_8321(pos) instanceof SubSystemBlockEntity be))
            return;
        if (!be.isLinked()) return;
        if (!(be.system() instanceof DurableSubSystem system)) return;

        float durability = system.durability();

        if (durability > 10) return;

        // smoke and spark particles & sfx when below 10%
        world.method_8466(class_2398.field_11251, true, pos.method_10263() + 0.5f, pos.method_10264() + 1,
                pos.method_10260() + 0.5f, 0.15, 0, 0);
        world.method_8406(class_2398.field_11204, pos.method_10263() + 0.5f, pos.method_10264() + 1, pos.method_10260() + 0.5f, 0.1,
                0, 0.05f);
        world.method_8406(class_2398.field_11239, pos.method_10263() + 0.5f, pos.method_10264() + 1, pos.method_10260() + 0.5f, 0.1,
                0, 0.05f);
        world.method_8406(class_2398.field_29644, pos.method_10263() + 0.5f, pos.method_10264() + 1, pos.method_10260() + 0.5f, 0.1,
                0, 0.05f);

        world.method_8466(class_2398.field_11251, true, pos.method_10263() + 0.5f, pos.method_10264() + 1,
                pos.method_10260() + 0.5f, -0.15, 0, 0);
        world.method_8406(class_2398.field_11204, pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f, -0.1,
                0, -0.05f);
        world.method_8406(class_2398.field_11239, pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f, -0.1,
                0, -0.05f);
        world.method_8406(class_2398.field_29644, pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f, -0.1,
                0, -0.05f);
    }
}
