package dev.amble.ait.core.engine.block.multi;

import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.SubSystemBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public abstract class StructureSystemBlockEntity extends SubSystemBlockEntity {
    protected StructureSystemBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, SubSystem.IdLike id) {
        super(type, pos, state, id);
    }

    public boolean isStructureComplete() {
        return this.isStructureComplete(this.method_10997(), this.method_11016());
    }
    public boolean isStructureComplete(class_1937 world, class_2338 pos) {
        return this.getStructure().check(world, pos);
    }
    protected boolean shouldRefresh(class_3218 world, class_2338 pos) {
        return world.method_8503().method_3780() % 40 == 0; // every 2 seconds
    }
    protected abstract MultiBlockStructure getStructure();

    @Override
    public void onGainFluid() {
        if (this.method_11002() && this.isStructureComplete()) {
            super.onGainFluid();
        }
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        super.tick(world, pos, state);

        if (world.method_8608()) return;

        if (this.shouldRefresh((class_3218) world, pos)) {
            this.processStructure();
        }
    }

    protected void processStructure() {
        boolean powered = this.isPowered();
        if (!powered) return;

        boolean complete = this.isStructureComplete();
        boolean broken = (this.system() instanceof DurableSubSystem durable) && durable.isBroken();
        boolean enabled = this.system().isEnabled();

        if (!complete && enabled) {
            this.onLoseFluid();
        }
        if (complete && !enabled && !broken) {
            this.onGainFluid();
        }
    }
}
