package dev.amble.ait.core.engine.link.block;

import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.engine.link.IFluidLink;
import dev.amble.ait.core.engine.link.IFluidSource;
import dev.amble.ait.core.world.TardisServerWorld;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public abstract class FluidLinkBlock extends class_2237 implements IFluidLink {
    public FluidLinkBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);

        if (!TardisServerWorld.isTardisDimension(world)) return;

        if (world.method_8321(pos) instanceof FluidLinkBlockEntity be) {
            be.onPlaced(world, pos, placer);
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) { // on break
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof FluidLinkBlockEntity be) {
                be.method_11012();
                be.onBroken(world, pos);
            }
        }

        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);

        if (world.method_8321(pos) instanceof FluidLinkBlockEntity be) {
            be.onNeighborUpdate(world, pos, sourceBlock, sourcePos);
        }
    }

    @Override
    public abstract FluidLinkBlockEntity method_10123(class_2338 pos, class_2680 state);

    @Override
    public IFluidSource source(boolean search) {
        throw new UnsupportedOperationException("FluidLinkBlock does not support this operation, did you mean to use FluidLinkBlockEntity?");
    }

    @Override
    public void setSource(IFluidSource source) {
        throw new UnsupportedOperationException("FluidLinkBlock does not support this operation, did you mean to use FluidLinkBlockEntity?");
    }

    @Override
    public IFluidLink last() {
        throw new UnsupportedOperationException("FluidLinkBlock does not support this operation, did you mean to use FluidLinkBlockEntity?");
    }

    @Override
    public void setLast(IFluidLink last) {
        throw new UnsupportedOperationException("FluidLinkBlock does not support this operation, did you mean to use FluidLinkBlockEntity?");
    }
}
