package dev.amble.ait.core.engine.link.tracker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.engine.link.IFluidLink;

public class WorldFluidTracker {
    public static HashMap<class_2350, IFluidLink> getConnections(class_3218 world, class_2338 pos, @Nullable class_2350 ignore) {
        // get all fluid links around the given position
        HashMap<class_2350, IFluidLink> connections = new HashMap<>();

        for (class_2350 dir : class_2350.values()) {
            if (dir == ignore) continue;

            IFluidLink found = query(world, pos.method_10093(dir));
            if (found == null) continue;

            connections.put(dir, found);
        }

        return connections;
    }
    public static LinkedList<IFluidLink> getAllConnections(class_3218 world, class_2338 pos, @Nullable class_2350 ignore, HashSet<class_2338> checkedPositions) {
        LinkedList<IFluidLink> list = new LinkedList<>();
        HashMap<class_2350, IFluidLink> connections;

        IFluidLink here = query(world, pos);
        if (here == null) {
            return list;
        }

        if (checkedPositions == null) checkedPositions = new HashSet<>();
        checkedPositions.add(pos);

        LinkedList<class_2338> toCheck = new LinkedList<>();
        toCheck.add(pos);

        while (!toCheck.isEmpty()) {
            class_2338 currentPos = toCheck.poll();
            connections = getConnections(world, currentPos, ignore);

            for (class_2350 direction : connections.keySet()) {
                if (direction == ignore) continue;

                class_2338 newPos = currentPos.method_10093(direction);
                if (checkedPositions.contains(newPos)) continue;
                if (checkedPositions.add(newPos)) {
                    toCheck.add(newPos);
                    list.add(connections.get(direction));
                }
            }
        }

        return list;
    }
    public static IFluidLink query(class_3218 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof IFluidLink link && !(be.method_11015())) {
            return link;
        }

        return null;
    }
}
