package dev.amble.ait.core.entities;

import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import io.netty.handler.codec.EncoderException;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1541;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.entity.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.entities.base.LinkableDummyEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.control.ControlBlockItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.ControlTypes;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;

public class ConsoleControlEntity extends LinkableDummyEntity {
    private static final class_2940<Float> WIDTH = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13320);
    private static final class_2940<Float> HEIGHT = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13320);
    private static final class_2940<Vector3f> OFFSET = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_42237);
    private static final class_2940<Boolean> PART_OF_SEQUENCE = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13323);
    private static final class_2940<Integer> SEQUENCE_INDEX = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13327); // <--->
    private static final class_2940<Integer> SEQUENCE_LENGTH = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13327);
    private static final class_2940<Boolean> WAS_SEQUENCED = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13323);
    private static final class_2940<Boolean> ON_DELAY = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13323);
    private static final class_2940<Float> DURABILITY = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13320);
    private static final class_2940<Boolean> STICKY = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13323);
    private static final class_2940<class_2338> CONSOLE_BLOCK_POS = class_2945.method_12791(ConsoleControlEntity.class,
            class_2943.field_13324);
    private Control control;
    private static final float MAX_DURABILITY = 1.0f;

    public ConsoleControlEntity(class_1299<? extends class_1297> entityType, class_1937 world) {
        super(entityType, world);
    }

    private ConsoleControlEntity(class_1937 world, Tardis tardis) {
        this(AITEntityTypes.CONTROL_ENTITY_TYPE, world);
        this.link(tardis);
    }

    public static ConsoleControlEntity create(class_1937 world, Tardis tardis) {
        return new ConsoleControlEntity(world, tardis);
    }

    @Override
    public void method_36209() {
        if (this.getConsoleBlockPos() == null) {
            super.method_36209();
            return;
        }

        if (this.method_37908().method_8321(this.getConsoleBlockPos()) instanceof ConsoleBlockEntity console)
            console.markNeedsControl();
    }

    @Override
    public void method_5693() {
        super.method_5693();

        this.field_6011.method_12784(WIDTH, 0.125f);
        this.field_6011.method_12784(HEIGHT, 0.125f);
        this.field_6011.method_12784(OFFSET, new Vector3f(0));
        this.field_6011.method_12784(PART_OF_SEQUENCE, false);
        this.field_6011.method_12784(SEQUENCE_INDEX, 0);
        this.field_6011.method_12784(SEQUENCE_LENGTH, 0);
        this.field_6011.method_12784(WAS_SEQUENCED, false);
        this.field_6011.method_12784(ON_DELAY, false);
        this.field_6011.method_12784(DURABILITY, MAX_DURABILITY);
        this.field_6011.method_12784(STICKY, false);
        this.field_6011.method_12784(CONSOLE_BLOCK_POS, class_2338.field_10980);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);

        nbt.method_10566("console", class_2512.method_10692(this.getConsoleBlockPos()));

        nbt.method_10548("width", this.getControlWidth());
        nbt.method_10548("height", this.getControlHeight());
        nbt.method_10548("offsetX", this.getOffset().x());
        nbt.method_10548("offsetY", this.getOffset().y());
        nbt.method_10548("offsetZ", this.getOffset().z());
        nbt.method_10556("partOfSequence", this.isPartOfSequence());
        nbt.method_10569("sequenceColor", this.getSequenceIndex());
        nbt.method_10556("wasSequenced", this.wasSequenced());
        nbt.method_10548("durability", this.getDurability());
        nbt.method_10556("sticky", this.isSticky());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);

        class_2487 console = nbt.method_10562("console");

        if (nbt.method_10545("console")) {
            this.setConsolePos(class_2512.method_10691(console));
        }

        if (nbt.method_10545("width") && nbt.method_10545("height")) {
            this.setControlWidth(nbt.method_10583("width"));
            this.setControlHeight(nbt.method_10583("height"));
            this.method_18382();
        }

        if (nbt.method_10545("offsetX") && nbt.method_10545("offsetY") && nbt.method_10545("offsetZ"))
            this.setOffset(new Vector3f(nbt.method_10583("offsetX"), nbt.method_10583("offsetY"), nbt.method_10583("offsetZ")));

        if (nbt.method_10545("partOfSequence"))
            this.setPartOfSequence(nbt.method_10577("partOfSequence"));

        if (nbt.method_10545("sequenceColor"))
            this.setSequenceIndex(nbt.method_10550("sequenceColor"));

        if (nbt.method_10545("wasSequenced"))
            this.setWasSequenced(nbt.method_10577("wasSequenced"));

        if (nbt.method_10545("durability"))
            this.setDurability(nbt.method_10583("durability"));
        if (nbt.method_10545("sticky"))
            this.setSticky(nbt.method_10577("sticky"));
    }

    public void setConsolePos(class_2338 consoleBlockPos) {
        this.field_6011.method_12778(CONSOLE_BLOCK_POS, consoleBlockPos);
    }

    @Override
    public void method_48850(List<class_2945.class_7834<?>> dataEntries) {
        this.setScaleAndCalculate(this.method_5841().method_12789(WIDTH), this.method_5841().method_12789(HEIGHT));
    }

    @Override
    public boolean method_5863() {
        return !method_31481();
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand);

        if (player.method_6079().method_31574(class_1802.field_8866)) {
            controlEditorHandler(player);
            return class_1269.field_5812;
        }

        if (handStack.method_31574(AITBlocks.REDSTONE_CONTROL_BLOCK.method_8389()) && this.getControl() != null) {
            class_2487 nbt = handStack.method_7948();
            nbt.method_10582(ControlBlockItem.CONTROL_ID_KEY, this.getControl().id().toString());
            ConsoleBlockEntity consoleBlockEntity = this.getConsole();
            nbt.method_10582(ControlBlockItem.CONSOLE_TYPE_ID_KEY, consoleBlockEntity.getTypeSchema().id().toString());
            return class_1269.field_5812;
        }

        if (hand == class_1268.field_5808 && !this.run(player, player.method_37908(), false))
            this.playFailFx();

        return class_1269.field_5812;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5526() instanceof class_1541)
            return false;

        if (source.method_5529() instanceof class_1657 player) {
            if (source.method_5526() instanceof class_1676)
                source.method_5526().method_31472();

            if (player.method_6079().method_31574(class_1802.field_8866))
                controlEditorHandler(player);

            else if (!this.run((class_1657) source.method_5529(), source.method_5529().method_37908(), true))
                this.playFailFx();
        }

        return false;
    }

    private void playFailFx() {
        if (this.method_37908().method_8608())
            return;

        class_3218 world = (class_3218) this.method_37908();

        // spawn particle above the control
        world.method_14199(AITMod.CORAL_PARTICLE, this.method_23317(), this.method_23318() + 0.25, this.method_23321(), 1, 0.05, 0.05, 0.05, 0.025);
        world.method_8396(null, this.method_24515(), class_3417.field_15239, class_3419.field_15245, 0.2F, AITMod.RANDOM.nextFloat(0.5F, 1.5F));
    }

    @Override
    public boolean method_5732() {
        return true;
    }

    @Override
    public class_4048 method_18377(class_4050 pose) {
        if (this.method_5841().method_51696(WIDTH) && this.method_5841().method_51696(HEIGHT))
            return class_4048.method_18384(this.getControlWidth(), this.getControlHeight());

        return super.method_18377(pose);
    }

    @Override
    public void method_5773() {
        if (this.method_37908().method_8608())
            return;

        if (this.control == null && this.getConsoleBlockPos() != null)
            this.method_31472();

        switch (this.getDurabilityState(this.getDurability())) {
            case JAMMED, SPARKING -> this.spark();
            case CATCH_FIRE -> this.onFire();
        }
    }

    @Override
    public boolean method_5733() {
        return true;
    }

    public float getControlWidth() {
        return this.field_6011.method_12789(WIDTH);
    }

    public float getControlHeight() {
        return this.field_6011.method_12789(HEIGHT);
    }

    public void setControlWidth(float width) {
        this.field_6011.method_12778(WIDTH, width);
    }

    public void setControlHeight(float height) {
        this.field_6011.method_12778(HEIGHT, height);
    }

    public Control getControl() {
        return control;
    }

    public Vector3f getOffset() {
        return this.field_6011.method_12789(OFFSET);
    }

    public void setOffset(Vector3f offset) {
        this.field_6011.method_12778(OFFSET, offset);
    }

    public int getSequenceIndex() {
        return this.field_6011.method_12789(SEQUENCE_INDEX);
    }

    public void setSequenceIndex(int i) {
        this.field_6011.method_12778(SEQUENCE_INDEX, i);
    }

    public int getSequenceLength() {
        return this.field_6011.method_12789(SEQUENCE_LENGTH);
    }

    public void setSequenceLength(int n) {
        this.field_6011.method_12778(SEQUENCE_LENGTH, n);
    }

    public float getSequencePercentage() {
        return (this.getSequenceIndex() + 1f) / this.getSequenceLength();
    }

    public boolean wasSequenced() {
        return this.field_6011.method_12789(WAS_SEQUENCED);
    }

    public void setWasSequenced(boolean sequenced) {
        this.field_6011.method_12778(WAS_SEQUENCED, sequenced);
    }

    public void setPartOfSequence(boolean partOfSequence) {
        this.field_6011.method_12778(PART_OF_SEQUENCE, partOfSequence);
    }

    public boolean isPartOfSequence() {
        return this.field_6011.method_12789(PART_OF_SEQUENCE);
    }

    public boolean isOnDelay() {
        return this.field_6011.method_12789(ON_DELAY);
    }

    public float getDurability() {
        return this.field_6011.method_12789(DURABILITY);
    }

    public boolean isSticky() {
        return this.field_6011.method_12789(STICKY);
    }

    public DurabilityStates getDurabilityState(float durability) {
        return DurabilityStates.get(durability);
    }

    public void setDurability(float durability) {
        this.field_6011.method_12778(DURABILITY, durability);
    }

    public void setSticky(boolean sticky) {
        this.field_6011.method_12778(STICKY, sticky);
    }

    public void addDurability(float durability) {
        this.setDurability(Math.min(durability, MAX_DURABILITY));
    }

    public void subtractDurability(float durability) {
        this.setDurability(Math.max(this.getDurability() - durability, 0));
    }

    public boolean run(class_1657 player, class_1937 world, boolean leftClick) {
        if (isSticky()) {
            if (player.method_6047().method_31574(class_1802.field_8868)) {
                this.method_5783(class_3417.field_14975, 1, 1);
                this.field_6011.method_12778(STICKY, false);
                return true;
            }

            this.method_5783(class_3417.field_15194, 0.4f, 1);
            player.method_37908().method_8406(
                    new class_2388(class_2398.field_11217, class_2246.field_10030.method_9564()),
                    this.method_23317(), this.method_23318(), this.method_23321(),
                    0.2, 0.5, -0.1
            );

            return true;
        } else if (player.method_6047().method_31574(class_1802.field_8777)) {
            this.method_5783(class_3417.field_15194, 1, 1);
            this.field_6011.method_12778(STICKY, true);
            return true;
        }

        if (world.method_8608())
            return false;

        if (player.method_6047().method_31574(AITItems.TARDIS_ITEM))
            this.method_31472();

        if (!this.isLinked()) {
            AITMod.LOGGER.warn("Discarding invalid control entity at {}; console pos: {}", this.method_19538(),
                    this.getConsoleBlockPos());

            this.method_31472();
            return false;
        }

        Tardis tardis = this.tardis().get();

        if (player.method_6047().method_31574(AITItems.SONIC_SCREWDRIVER) && this.getDurability() < 1.0f
                && SonicItem.mode(player.method_6047()) == SonicMode.Modes.TARDIS) {
            class_243 pos = this.method_19538();
            this.method_5783(class_3417.field_14627, 1, 1);
            ((class_3218) this.method_5770()).method_14199(class_2398.field_29642,
                    pos.method_10216(), pos.method_10214(), pos.method_10215(), 2, 0.2, 0.4, 0.2, 0.02);
            this.setDurability(MAX_DURABILITY);
            return true;
        }

        control.runAnimation(tardis, (class_3222) player, (class_3218) world);

        if (this.isOnDelay())
            return false;

        if (!this.control.canRun(tardis, (class_3222) player))
            return false;

        if (world.method_8409().method_39332(1, 10_000) == 72)
            this.method_37908().method_8396(null, this.method_24515(), AITSounds.EVEN_MORE_SECRET_MUSIC, class_3419.field_15250,
                    1F, 1F);

        boolean hasMallet = player.method_6047().method_31574(AITItems.HAMMER);

        if (hasMallet) {
            this.method_5783(AITSounds.KNOCK, 1, 0.25f);
            class_243 pos = this.method_19538();
            ((class_3218) world).method_14199(class_2398.field_29645,
                    pos.method_10216(), pos.method_10214(), pos.method_10215(), 2, 0.2, 0.4, 0.2, 0.02);
        }

        DurabilityStates state = this.getDurabilityState(this.getDurability());

        if (state == DurabilityStates.FULL) {
            if (hasMallet)
                this.subtractDurability(0.1f);
        }

        if (state == DurabilityStates.JAMMED) {
            if (!hasMallet) return false;
        }

        if (state == DurabilityStates.OCCASIONALLY_JAM && field_5974.method_39332(0, 10) == 5) {
            if (hasMallet) {
                this.setDurability(state.next().durability);
            } else {
                return false;
            }
        }

        if (state == DurabilityStates.SPARKING && field_5974.method_39332(0, 10) < 5) {
            if (hasMallet) {
                this.setDurability(state.next().durability);
            } else {
                return false;
            }
        }

        if (this.control.shouldHaveDelay(tardis) && !this.isOnDelay()) {
            this.field_6011.method_12778(ON_DELAY, true);

            Scheduler.get().runTaskLater(() -> this.field_6011.method_12778(ON_DELAY, false),
                    TaskStage.END_SERVER_TICK, TimeUnit.TICKS, this.control.getDelayLength(tardis));
        }

        Control.Result result = this.control.handleRun(tardis, (class_3222) player, (class_3218) world, this.getConsoleBlockPos(), leftClick);

        if (result == Control.Result.SEQUENCE) {
            // THIS IS LITERALLY A FEATURE DON'T REMOVE UNLESS I SAY SO DAMMIT - Loqor
            if (field_5974.method_39332(0, 10) == 5) {
                int subtractCauseICan = field_5974.method_39332(0, 200);
                this.subtractDurability(subtractCauseICan / 200f);
            }
        }

        ConsoleBlockEntity console = this.getConsole();
        if (console != null) {
            this.method_37908().method_8396(null, this.method_24515(), this.control.getSound(console.getTypeSchema(), result), class_3419.field_15245, 0.7f,
                    1f);
        }

        return result.isSuccess();
    }

    public ConsoleBlockEntity getConsole() {
        if (this.getConsoleBlockPos() == null)
            return null;

        class_2586 blockEntity = this.method_37908().method_8321(this.getConsoleBlockPos());
        if (blockEntity instanceof ConsoleBlockEntity console)
            return console;

        AITMod.LOGGER.warn("Control entity at {} has no console block entity at {}", this.method_19538(), this.getConsoleBlockPos());
        return null;
    }

    private void spark() {
        if (this.method_5770().method_8608()) return;
        class_243 pos = this.method_19538();
        ((class_3218) this.method_5770()).method_14199(class_2398.field_11251, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0, 0.1, 0, 0.01f);
        if (field_5974.method_39332(0, 40) == 5 && field_5974.method_43056()) {
            this.method_5783(class_3417.field_24065, 0.1f, field_5974.method_43056() ? 1f : 2f);
            ((class_3218) this.method_5770()).method_14199(class_2398.field_29644, pos.method_10216(), pos.method_10214(), pos.method_10215(), 5, 0.2, 0.2, 0.2, 0.01);
            ((class_3218) this.method_5770()).method_14199(class_2398.field_11239, pos.method_10216(), pos.method_10214(), pos.method_10215(), 3, 0.1, 0.1, 0.1, 0.01);
        }
        this.onFire();
    }

    private void onFire() {
        if (this.method_5770().method_8608()) return;
        class_243 pos = this.method_19538();
        ((class_3218) this.method_5770()).method_14199(class_2398.field_11251, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0, 0, 0, 0.0f);
        if (this.method_5770().method_8503().method_3780() % 10 == 0)
            ((class_3218) this.method_5770()).method_14199(class_2398.field_27783, pos.method_10216(), pos.method_10214() + 0.2f, pos.method_10215(), 1, 0, 0.075f, 0, 0);
    }

    public class_2338 getConsoleBlockPos() {
        return this.field_6011.method_12789(CONSOLE_BLOCK_POS);
    }

    public void setScaleAndCalculate(float width, float height) {
        this.setControlWidth(width);
        this.setControlHeight(height);
        this.method_18382();
    }

    public void setControlData(ConsoleTypeSchema consoleType, ControlTypes type, class_2338 consoleBlockPosition) {
        this.setConsolePos(consoleBlockPosition);
        this.control = type.getControl();

        super.method_5665(class_2561.method_43471(this.control.id().method_42093("control")));

        if (consoleType != null) {
            this.setControlWidth(type.getScale().field_18067);
            this.setControlHeight(type.getScale().field_18068);
            this.setOffset(type.getOffset());
        }
    }

    public void logConsoleJson() {
        // convert all controls into json
        JsonArray root = new JsonArray();

        for (ConsoleControlEntity entity : this.getConsole().controlEntities) {
            if (entity == null) continue;

            ControlTypes type = new ControlTypes(entity.getControl(), entity.method_18377(class_4050.field_18076), entity.getOffset());
            DataResult<JsonElement> dataResult = ControlTypes.CODEC.encodeStart(JsonOps.INSTANCE, type);
            JsonElement typeData = class_156.method_47526(dataResult, error -> new EncoderException("Failed to encode: " + error + " " + type));

            root.add(typeData);
        }

        AITMod.LOGGER.info(TardisManager.getInstance(this).getFileGson().toJson(root));
    }

    public void controlEditorHandler(class_1657 player) {
        if (!player.method_7338()) return;

        float increment = 0.0125f;

        if (player.method_6047().method_7909() == class_1802.field_8407 && !player.method_37908().method_8608()) {
            logConsoleJson();

            player.method_43496(class_2561.method_43470("JSON Data logged to Java Console!"));

            return;
        }

        if (player.method_6047().method_7909() == class_1802.field_8733)
            this.method_33574(this.method_19538().method_1031(player.method_5715() ? -increment : increment, 0, 0));

        if (player.method_6047().method_7909() == class_1802.field_8603)
            this.method_33574(this.method_19538().method_1031(0, player.method_5715() ? -increment : increment, 0));

        if (player.method_6047().method_7909() == class_1802.field_8793)
            this.method_33574(this.method_19538().method_1031(0, 0, player.method_5715() ? -increment : increment));

        if (player.method_6047().method_7909() == class_1802.field_8429)
            this.setScaleAndCalculate(player.method_5715()
                    ? this.method_5841().method_12789(WIDTH) - increment
                    : this.method_5841().method_12789(WIDTH) + increment, this.method_5841().method_12789(HEIGHT));

        if (player.method_6047().method_7909() == class_1802.field_8373)
            this.setScaleAndCalculate(this.method_5841().method_12789(WIDTH),
                    player.method_5715()
                            ? this.method_5841().method_12789(HEIGHT) - increment
                            : this.method_5841().method_12789(HEIGHT) + increment);

        if (this.getConsoleBlockPos() != null) {
            class_243 centered = this.method_19538().method_1020(this.getConsoleBlockPos().method_46558());
            this.setOffset(centered.method_46409());
            if (this.control != null)
                player.method_43496(class_2561.method_43470("EntityDimensions.changing(" + this.getControlWidth() + "f, "
                        + this.getControlHeight() + "f), new Vector3f(" + centered.method_10216() + "f, " + centered.method_10214()
                        + "f, " + centered.method_10215() + "f)),"));
        }
    }

    @Override
    public void method_5665(@Nullable class_2561 name) {}

    public enum DurabilityStates {
        JAMMED(0.0f),
        CATCH_FIRE(0.25f),
        SPARKING(0.5f),
        OCCASIONALLY_JAM(0.75f),
        FULL(ConsoleControlEntity.MAX_DURABILITY);
        public final float durability;
        DurabilityStates(float durabilityLevel) {
            this.durability = durabilityLevel;
        }

        public static DurabilityStates get(String id) {
            return DurabilityStates.valueOf(id.toUpperCase());
        }

        public static DurabilityStates get(float level) {
            level = DurabilityStates.normalize(level);

            for (int i = 0; i < values().length - 1; i++) {
                DurabilityStates current = values()[i];
                DurabilityStates next = values()[i + 1];

                if (current.durability <= level && level < next.durability)
                    return current;
            }

            return DurabilityStates.FULL;
        }

        public static float normalize(float durability) {
            return Math.min(Math.max(durability, DurabilityStates.JAMMED.durability), DurabilityStates.FULL.durability);
        }

        public DurabilityStates next() {
            return switch (this) {
                case JAMMED -> CATCH_FIRE;
                case CATCH_FIRE -> SPARKING;
                case SPARKING -> OCCASIONALLY_JAM;
                case OCCASIONALLY_JAM -> FULL;
                case FULL -> JAMMED;
            };
        }
    }
}
