package dev.amble.ait.core.entities;

import java.util.List;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import org.jetbrains.annotations.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1316;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5498;
import net.minecraft.class_7718;
import net.minecraft.entity.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableLivingEntity;
import dev.amble.ait.client.util.ClientShakeUtil;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.AITEntityTypes;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.control.impl.DirectionControl;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.mixin.rwf.LivingEntityAccessor;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetRegistry;

public class FlightTardisEntity extends LinkableLivingEntity implements class_1316 {

    private static final List<class_1799> EMPTY = List.of();
    private static final class_1799 AIR = new class_1799(class_1802.field_8162);
    public float speedPitch;
    private class_243 lastVelocity;
    private class_2338 interiorPos;

    public FlightTardisEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);

        this.method_5684(true);
        this.lastVelocity = class_243.field_1353;
    }

    private FlightTardisEntity(class_2338 riderPos, CachedDirectedGlobalPos pos, ServerTardis tardis) {
        this(AITEntityTypes.FLIGHT_TARDIS_TYPE, pos.getWorld());

        this.interiorPos = riderPos;

        this.link(tardis);
        this.method_33574(pos.getPos().method_46558());
        this.method_18799(class_243.field_1353);

        this.method_5710(class_7718.method_45482(
                DirectionControl.getGeneralizedRotation(pos.getRotation())
        ), 0);
    }

    public static FlightTardisEntity createAndSpawn(class_3222 player, ServerTardis tardis) {
        CachedDirectedGlobalPos exteriorPos = tardis.travel().position();

        FlightTardisEntity entity = new FlightTardisEntity(
                player.method_24515(), exteriorPos, tardis
        );

        exteriorPos.getWorld().method_8649(entity);
        return entity;
    }

    @Override
    public boolean method_5740() {
        return true;
    }

    @Override
    protected float method_49484() {
        if (this.isLinked()  && this.tardis().get().travel() != null) {
            float spaceSpeed = this.method_37908().method_27983().equals(AITDimensions.SPACE) ? 0.1f : 0.05f;
            return this.method_6029() * (this.tardis().get().travel().speed() * spaceSpeed);
        }
        return super.method_49484();
    }

    @Override
    public void method_5773() {
        this.lastVelocity = this.method_18798();
        this.method_5710(0, 0);
        super.method_5773();

        class_1657 player = this.getPlayer();

        if (player == null)
            return;

        if (!this.isLinked())
            return;

        Tardis tardis = this.tardis().get();

        if (player.method_5715() && (this.method_24828() || tardis.travel().antigravs().get())
                && this.method_37908().method_24794(this.method_24515()))
            this.finishLand(tardis, player);

        if (this.method_37908().method_8608()) {
            class_310 client = class_310.method_1551();

            if (client.field_1724 == this.method_5642()) {
                client.field_1690.method_31043(class_5498.field_26665);

                if (!this.field_36331)
                    ClientShakeUtil.shake((float) (tardis.travel().speed() + this.method_18798().method_37267()) / tardis.travel().maxSpeed().get());
            }

            return;
        }

        if (!player.method_5767())
            player.method_5648(true);

        if (!player.method_5655())
            player.method_5684(true);

        tardis.flight().tickFlight((class_3222) player);

        if (tardis.door().isOpen()) {
            this.method_37908().method_8333(this, this.method_5829(), entity
                    -> !entity.method_7325() && entity != player && entity instanceof class_1309).forEach(
                    entity -> TardisUtil.teleportInside(tardis.asServer(), entity)
            );
        }
    }

    @Override
    public void method_52208(boolean onGround, class_243 movement) {
        if (!this.method_24828() && onGround)
            this.playThud();

        super.method_52208(onGround, movement);
    }

    @Override
    public void method_24830(boolean onGround) {
        if (!this.method_24828() && onGround)
            this.playThud();

        super.method_24830(onGround);
    }

    private void playThud() {
        this.method_37908().method_8396(null, this.method_24515(), AITSounds.LAND_THUD, class_3419.field_15245, 2F, 1F / (AITMod.RANDOM.nextFloat() * 0.4F + 0.8F));
    }

    private void finishLand(Tardis tardis, class_1657 player) {
        if (this.method_37908().method_8608()) {
            class_310 client = class_310.method_1551();
            client.field_1690.method_31043(class_5498.field_26665);
            client.field_1690.field_1842 = false;
            return;
        }

        if (!(player instanceof class_3222 serverPlayer))
            return;

        if (this.interiorPos == null) {
            TardisUtil.teleportInside(tardis.asServer(), serverPlayer);
        } else {
            TardisUtil.teleportToInteriorPosition(tardis.asServer(), serverPlayer, this.interiorPos);
        }

        tardis.flight().exitFlight(serverPlayer);
        tardis.travel().speed(0);
        this.method_31472();
    }

    @Override
    public boolean method_5862() {
        return false;
    }

    @Override
    public Iterable<class_1799> method_5661() {
        return EMPTY;
    }

    @Override
    public class_1799 method_6118(class_1304 slot) {
        return AIR;
    }

    @Override
    public void method_5673(class_1304 slot, class_1799 stack) { }

    @Override
    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1657 getPlayer() {
        if (this.method_5642() instanceof class_1657 player)
            return player;

        return null;
    }

    @Nullable @Override
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();

        if (entity instanceof class_1309 living)
            return living;

        return null;
    }

    @Override
    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        if (!this.isLinked() || !this.tardis().get().fuel().hasPower()) return new class_243(0, 0, 0);
        float f = controllingPlayer.field_6212 * this.tardis().get().travel().speed();
        float g = controllingPlayer.field_6250 * this.tardis().get().travel().speed();

        float speedVal = this.method_5869() ? 30f : 10f;

        Planet planet = PlanetRegistry.getInstance().get(this.method_37908());
        boolean canFall = this.tardis().get().travel().antigravs().get() || planet != null && planet.zeroGravity();

        double v = ((LivingEntityAccessor) controllingPlayer).getJumping() ? speedVal :
                controllingPlayer.method_5715() ? -speedVal :
                        canFall ? 0.0f : f > 0 || g > 0 ? -0.5f : -2f;

        if (v < 0 && this.method_24828())
            return class_243.field_1353.method_1031(0, -0.4f, 0);
        class_243 yourmom = new class_243(f, v, g);
        return yourmom;//return this.isOnGround() ? new Vec3d(0, 0, 0) : new Vec3d(f, v * 4f, g);
    }

    @Override
    protected float method_49485(class_1657 controllingPlayer) {
        return (float) this.method_26825(class_5134.field_23719);
    }

    @Override
    public double method_5621() {
        return 0.5f;
    }

    public float getRotation(float tickDelta) {
        return ((float) this.field_6012 + tickDelta) / 20.0f;
    }

    public class_243 lerpVelocity(float tickDelta) {
        return this.lastVelocity.method_35590(this.method_18798(), tickDelta);
    }

    @Override
    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        class_241 vec2f = new class_241(0, controllingPlayer.method_36454());
        this.method_5710(vec2f.field_1342, vec2f.field_1343);

        this.method_5636(180.0f - this.getRotation(0.5f) / (float) Math.PI * 180f);
    }

    @Override
    public boolean method_30948() {
        return true;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);

        if (nbt.method_10545("InteriorPos")) {
            this.interiorPos = class_2338.method_10092(nbt.method_10537("InteriorPos"));
        } else {
            this.interiorPos = class_2338.field_10980;
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.method_37908().method_8608()) return;
        if (!this.isLinked()) return;


        TardisDesktop desktop = tardis().get().getDesktop();

        if (interiorPos == null)
            interiorPos = desktop.getConsolePos().iterator().next();

        if (interiorPos == null)
            interiorPos = desktop.getDoorPos().getPos();

        if (interiorPos == null)
            interiorPos = new class_2338(0, 0, 0);

        nbt.method_10544("InteriorPos", interiorPos.method_10063());
    }

    public static class_5132.class_5133 createDummyAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 1)
                .method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 0)
                .method_26868(class_5134.field_23720, 5);
    }

    @Override
    public void method_6154(int strength) {
    }

    @Override
    public boolean method_6153() {
        return false;
    }

    @Override
    public void method_6155(int height) { }

    @Override
    public void method_6156() { }
}
