package dev.amble.ait.core.events;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

public class ServerChunkEvents {

    public static final Event<Tick> TICK = EventFactory.createArrayBacked(Tick.class,
            callbacks -> (world, chunk) -> {
                for (Tick callback : callbacks) {
                    callback.onChunkTick(world, chunk);
                }
            });

    @FunctionalInterface
    public interface Tick {
        void onChunkTick(class_3218 world, class_2818 chunk);
    }
}
