package dev.amble.ait.core.handles;

import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.util.Levenshtein;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

/**
 * For Handles the robot, this is used to handle responses.
 * @author james
 */
public interface HandlesResponse extends Identifiable {
    /**
     * Send a chat message to the target player.
     * Auto prefixed with <Handles> for the message.
     * @param target The player to send the message to.
     * @param message The message to send.
     */
    default void sendChat(class_3222 target, class_2561 message) {
        message = class_2561.method_43470("<Handles> ").method_10852(message);
        target.method_7353(message, false);
    }

    /**
     * @return The sound to play when the command fails.
     */
    default class_3414 failureSound() {
        return AITSounds.HANDLES_DENIED;
    }

    /**
     * @return The sound to play when the command succeeds.
     */
    default class_3414 successSound() {
        return AITSounds.HANDLES_AFFIRMATIVE;
    }

    default boolean success(HandlesSound source) {
        source.playSound(successSound(), class_3419.field_15248, 1.0f, 1.0f);
        return true;
    }

    default boolean failure(HandlesSound source) {
        source.playSound(failureSound(), class_3419.field_15248, 1.0f, 1.0f);
        return false;
    }

    /**
     * Run the responses.
     * @param player player who invoked this responses
     * @param source sound handler
     * @param tardis handles linked tardis
     * @return Whether the responses was successful.
     */
    boolean run(class_3222 player, HandlesSound source, ServerTardis tardis);

    /**
     * @param command keyword to search for
     * @return whether the word given is a command word for this responses
     */
    default boolean isCommand(String command) {
        return getCommandWords().contains(command.toLowerCase());
    }

    // i have no idea how this shit fucking works
    default int distance(String command, String input) {
        return Levenshtein.distance(command, input);
    }

    /**
     * @return Whether a non-secure person can run the command when P19 is on.
     */
    default boolean requiresSudo() {
        return true;
    }

    /**
     * @return The command words that this responses can handle.
     */
    List<String> getCommandWords();
}
