package dev.amble.ait.core.handles;

import dev.amble.ait.core.tardis.ServerTardis;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

/**
 * For Handles the robot, this is used to play sounds.
 */
public interface HandlesSound {
    void playSound(class_3414 sound, class_3419 category, float volume, float pitch);

    static HandlesSound of(class_3222 player) {
        return (sound, category, volume, pitch) -> player.method_51469().method_8396(null, player.method_24515(), sound, category, volume, pitch);
    }
    static HandlesSound of(ServerTardis tardis) {
        return (sound, category, volume, pitch) -> tardis.getDesktop().playSoundAtEveryConsole(sound, category, volume, pitch);
    }
}
