package dev.amble.ait.core.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;

public class ArtronCollectorItem extends class_1792 {
    public static final String AU_LEVEL = "au_level";
    public static final String UUID_KEY = "uuid";
    public static final Integer COLLECTOR_MAX_FUEL = 1500;

    public ArtronCollectorItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1799 method_7854() {
        class_1799 stack = new class_1799(this);
        class_2487 nbt = stack.method_7948();
        nbt.method_10549(AU_LEVEL, 0);
        return super.method_7854();
    }

    public static UUID getUuid(class_1799 stack) {
        class_2487 nbt = stack.method_7948();

        if (nbt.method_10545(UUID_KEY))
            return nbt.method_25926(UUID_KEY);
        nbt.method_25927(UUID_KEY, UUID.randomUUID());
        return nbt.method_25926(UUID_KEY);
    }

    public static double getFuel(class_1799 stack) {
        class_2487 nbt = stack.method_7948();

        if (nbt.method_10545(AU_LEVEL))
            return nbt.method_10574(AU_LEVEL);
        nbt.method_10549(AU_LEVEL, 0);
        return 0d;
    }

    public static double addFuel(class_1799 stack, double fuel) {
        class_2487 nbt = stack.method_7948();
        double currentFuel = getFuel(stack);
        nbt.method_10549(AU_LEVEL, getFuel(stack) <= COLLECTOR_MAX_FUEL ? getFuel(stack) + fuel : COLLECTOR_MAX_FUEL);
        if (getFuel(stack) > COLLECTOR_MAX_FUEL)
            nbt.method_10549(AU_LEVEL, COLLECTOR_MAX_FUEL);
        if (getFuel(stack) == COLLECTOR_MAX_FUEL)
            return fuel - (COLLECTOR_MAX_FUEL - currentFuel);
        return 0;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_1799 cellItemStack = context.method_8041();
        class_2487 nbt = cellItemStack.method_7948();

        if (world.method_8608())
            return class_1269.field_5812;

        if (player.method_5715()) {
            if (world.method_8321(clickedPos) instanceof ExteriorBlockEntity exterior) {
                if (exterior.tardis().isEmpty())
                    return class_1269.field_5814;

                double residual = exterior.tardis().get().addFuel(nbt.method_10574(AU_LEVEL));
                nbt.method_10549(AU_LEVEL, residual);
                return class_1269.field_21466;
            } else if (world.method_8321(clickedPos) instanceof ConsoleBlockEntity console) {
                if (console.tardis().isEmpty())
                    return class_1269.field_5814;

                double residual = console.tardis().get().addFuel(nbt.method_10574(AU_LEVEL));
                nbt.method_10549(AU_LEVEL, residual);
                return class_1269.field_21466;
            }
            return class_1269.field_5814;
        }

        return class_1269.field_5814;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 tag = stack.method_7948();
        String text = tag.method_10545(AU_LEVEL) ? "" + tag.method_10574(AU_LEVEL) : "0.0";
        tooltip.add(class_2561.method_43470(text + " / " + COLLECTOR_MAX_FUEL + ".0").method_27692(class_124.field_1078));
    }
}
