package dev.amble.ait.core.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.core.AITBlocks;

public class ChargedZeitonCrystalItem extends class_1792 implements ArtronHolderItem {
    public static final double MAX_FUEL = 5000;

    public ChargedZeitonCrystalItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1799 method_7854() {
        class_1799 stack = new class_1799(this);
        class_2487 nbt = stack.method_7948();

        nbt.method_10549(FUEL_KEY, getMaxFuel(stack));

        return stack;
    }

    @Override
    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_7843(stack, world, player);
        class_2487 nbt = stack.method_7948();
        nbt.method_10549(FUEL_KEY, 0);
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return MAX_FUEL;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int currentFuel = (int) Math.round(this.getCurrentFuel(stack));
        class_124 fuelColor = currentFuel > (MAX_FUEL / 4) ? class_124.field_1060 : class_124.field_1061;

        tooltip.add(
                class_2561.method_43469("message.ait.artron_units", currentFuel)
                        .method_27692(fuelColor)
                        .method_10852(class_2561.method_43470(" / ").method_27692(class_124.field_1080))
                        .method_10852(class_2561.method_43470(String.valueOf(MAX_FUEL)).method_27692(class_124.field_1080))
        );

        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2680 state = context.method_8045().method_8320(context.method_8037());

        if (state.method_27852(AITBlocks.ZEITON_COBBLE)) {
            context.method_8045().method_8501(context.method_8037(), AITBlocks.COMPACT_ZEITON.method_9564());
            context.method_8041().method_7934(1);
            return class_1269.field_5812;
        }

        return super.method_7884(context);
    }
}
