package dev.amble.ait.core.item;

import org.joml.Vector3f;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.blocks.PeanutBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5743;

public class HammerItem extends class_1829 {

    public HammerItem(int attackDamage, float attackSpeed, class_1793 settings) {
        super(class_1834.field_8923, attackDamage, attackSpeed, settings);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (state.method_27852(class_2246.field_10085)) {
            return 15.0F;
        } else {
            return state.method_26164(class_3481.field_44469) ? 1.5F : 1.0F;
        }
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();

        if (!(context.method_8045() instanceof class_3218 world))
            return class_1269.field_5812;

        if (world.method_8320(pos).method_26204() instanceof PeanutBlock peanut)
            peanut.explode(context.method_8045(), pos);

        if (!(world.method_8321(pos) instanceof ConsoleBlockEntity consoleBlockEntity))
            return class_1269.field_5811;

        if (player == null || !consoleBlockEntity.isLinked())
            return class_1269.field_5811;

        Tardis tardis = consoleBlockEntity.tardis().get();

        TravelHandler travel = tardis.travel();

        if (player.method_7357().method_7904(stack.method_7909()))
            return class_1269.field_5811;

        if (!(tardis.travel().getState() == TravelHandlerBase.State.FLIGHT)) {

            if (!player.method_7357().method_7904(stack.method_7909())) {

                int hammerUses = travel.getHammerUses();
                world.method_8396(null, consoleBlockEntity.method_11016(), AITSounds.HAMMER_HIT, class_3419.field_15245,
                        1f, 1.0f);
                tardis.loyalty().subLevel((class_3222) player, 10); // safe cast since its on server already

                if (hammerUses > 3) {
                    world.method_43129(null, player, AITSounds.HAMMER_STRIKE, class_3419.field_15248, 0.5f, 0.2f);

                    tardis.door().closeDoors();
                    tardis.door().setLocked(true);

                    travel.handbrake(false);
                    tardis.addFuel(10);
                    travel.dematerialize();
                    tardis.alarm().isEnabled();

                    world.method_14199(class_2398.field_27783, pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f,
                            5 * hammerUses, 0, 0, 0, 0.1f * hammerUses);

                    world.method_14199(class_2398.field_11236, pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f,
                            5 * hammerUses, 0, 0, 0, 0.1f * hammerUses);

                    world.method_14199(
                            new class_5743(new Vector3f(0.75f, 0.75f, 0.75f), new Vector3f(0.1f, 0.1f, 0.1f),
                                    1),
                            pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f, 5 * hammerUses, 0, 0, 0, 0.1f * hammerUses);

                    world.method_46407(null, world.method_48963().method_48829(), TardisUtil.EXPLOSION_BEHAVIOR, pos.method_46558(), 5, TardisUtil.doCreateFire(world),
                            class_1937.class_7867.field_40890);

                    tardis.loyalty().subLevel((class_3222) player, 50); // safe cast since its on server already
                    player.method_7357().method_7906(stack.method_7909(), 10 * 20);
                    return class_1269.field_5812;
                }
            }
        }


        int targetTicks = travel.getTargetTicks();
        int currentFlightTicks = travel.getFlightTicks();
        int bonus = 500 * travel.speed();
        int hammerUses = travel.getHammerUses();

        double fuel = tardis.fuel().getCurrentFuel();
        double maxFuel = tardis.fuel().getMaxFuel();

        double fuelCost = bonus / 5.0;

        if (hammerUses > 0) {
            bonus -= (int) Math.round(bonus * 0.1 * hammerUses);
            fuelCost += (150 * travel.speed() * hammerUses) / 7.0;
        }

        if (!world.method_8608() && fuel + fuelCost > maxFuel) {
            travel.crash();

            tardis.fuel().setCurrentFuel(0.0);
            return class_1269.field_5812;
        }

        travel.setFlightTicks(Math.min(currentFlightTicks + bonus, targetTicks));
        tardis.fuel().setCurrentFuel(fuel - fuelCost);
        travel.useHammer();

        if (!world.method_8608() && shouldCrashTardis(hammerUses)) {
            travel.crash();
        } else {
            world.method_8396(null, consoleBlockEntity.method_11016(), class_3417.field_15152, class_3419.field_15245,
                    0.25f * hammerUses, 1.0f);
        }

        if (world.method_8608())
            return class_1269.field_5811;

        world.method_14199(class_2398.field_27783, pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f,
                5 * hammerUses, 0, 0, 0, 0.1f * hammerUses);

        world.method_14199(
                new class_5743(new Vector3f(0.75f, 0.75f, 0.75f), new Vector3f(0.1f, 0.1f, 0.1f),
                        1),
                pos.method_10263() + 0.5f, pos.method_10264() + 1.25, pos.method_10260() + 0.5f, 5 * hammerUses, 0, 0, 0, 0.1f * hammerUses);

        world.method_8396(null, consoleBlockEntity.method_11016(), class_3417.field_29189,
                class_3419.field_15245, 0.25f * hammerUses, 1.0f);

        return class_1269.field_5812;
    }

    public boolean shouldCrashTardis(int annoyance) {
        if (annoyance <= 3)
            return false;

        for (int i = 0; i < annoyance; i++) {
            if (AITMod.RANDOM.nextInt(0, 10) == 1)
                return true;
        }

        return false;
    }

    @Override
    public boolean method_7856(class_2680 state) {
        return state.method_27852(class_2246.field_10085);
    }
}
