package dev.amble.ait.core.item;

import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.Loyalty;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class InteriorTeleporterItem extends LinkableItem { // todo - new model + texture?
    private static final class_2394 PARTICLE_SUCCESS = class_2398.field_28479;
    private static final class_2394 PARTICLE_FAIL = class_2398.field_29644;

    public InteriorTeleporterItem(class_1793 settings) {
        super(settings.method_7889(1).method_7898(16), true);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        Tardis tardis = getTardis(world, stack);

        if (world.method_8608()) {
            boolean success = (tardis != null);

            if (success) {
                class_310.method_1551().field_1773.method_3189(stack);
            }

            return success ? class_1271.method_29237(stack, true) : class_1271.method_22431(stack);
        }
        // server-side

        if (tardis == null)
            return class_1271.method_22431(stack);

        Loyalty loyalty = tardis.loyalty().get(user);
        Loyalty.Type type = loyalty.type();

        boolean success = switch (type) {
            case REJECT, NEUTRAL -> false;
            case PILOT, OWNER -> true;

            case COMPANION -> tardis.travel().isLanded();
        };

        if (!success) {
            createTeleportEffect((class_3222) user, PARTICLE_FAIL);
            world.method_8396(null, user.method_24515(), AITSounds.UNSTABLE_FLIGHT_LOOP, class_3419.field_15248, 1f, 1f);
            user.method_7357().method_7906(this, 4 * 20);

            return class_1271.method_22431(stack);
        }

        createTeleportEffect((class_3222) user, PARTICLE_SUCCESS);
        world.method_8396(null, user.method_24515(), AITSounds.BWEEP, class_3419.field_15248, 1f, 1f);

        TardisUtil.teleportInside(tardis.asServer(), user);

        stack.method_7939(stack.method_7947() - 1);
        user.method_7357().method_7906(this, 16 * 20);

        class_2338 door = tardis.getDesktop().getDoorPos().getPos();
        createTeleportEffect(tardis.asServer().world(), door.method_46558().method_1023(0, 0.5, 0), PARTICLE_SUCCESS);
        world.method_8396(null, door, AITSounds.DING, class_3419.field_15248, 1f, 1f);
        world.method_8396(null, door, AITSounds.LAND_THUD, class_3419.field_15248, 1f, 1f);

        return class_1271.method_29237(stack, true);
    }

    /**
     * Creates a spiral of particles around the player
     * <br>
     * from <a href="https://github.com/Duzos/vortex-manipulator/blob/trunk/src/main/java/mc/duzo/vortex/util/VortexUtil.java">this mod</a>
     */
    private static void createTeleportEffect(class_3218 world, class_243 source, class_2394 particle) {
        double b = Math.PI / 8;

        class_243 pos;
        double x;
        double y;
        double z;

        for(double t = 0.0D; t <= Math.PI * 2; t += Math.PI / 16) {
            for (int i = 0; i <= 1; i++) {
                x = 0.4D * (Math.PI * 2 - t) * 0.5D * Math.cos(t + b + i * Math.PI);
                y = 0.5D * t;
                z = 0.4D * (Math.PI * 2 - t) * 0.5D * Math.sin(t + b + i * Math.PI);
                pos = source.method_1031(x, y, z);

                world.method_14199(particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.0D, 0.0D, 0.0D, 0.0D);
            }
        }
    }
    private static void createTeleportEffect(class_3222 player, class_2394 particle) {
        class_243 dest = player.method_24515().method_46558().method_1023(0, 0.5, 0);
        createTeleportEffect(player.method_51469(), dest, particle);
    }
}
