package dev.amble.ait.core.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7718;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.enummap.EnumSet;
import dev.amble.ait.data.enummap.Ordered;

public class KeyItem extends LinkableItem {

    private final EnumSet<Protocols> protocols;

    public KeyItem(class_1793 settings, Protocols... abs) {
        super(settings.method_7889(1), true);

        this.protocols = new EnumSet<>(Protocols::values);
        this.protocols.addAll(abs);
    }

    public enum Protocols implements Ordered {
        SNAP, HAIL, PERCEPTION, SKELETON;

        @Override
        public int index() {
            return ordinal();
        }
    }

    public boolean hasProtocol(Protocols var) {
        return this.protocols.contains(var);
    }

    public static boolean isKeyInInventory(class_1657 player) {
        return player.method_31548().method_7382(AITTags.Items.KEY);
    }

    public static Collection<class_1799> getKeysInInventory(class_1657 player) {
        List<class_1799> items = new ArrayList<>();

        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack != null && stack.method_7909() instanceof KeyItem)
                items.add(stack);
        }

        return items;
    }

    public static boolean hasMatchingKeyInInventory(class_1657 player, Tardis tardis) {
        Collection<class_1799> keys = getKeysInInventory(player);

        for (class_1799 stack : keys) {
            KeyItem key = (KeyItem) stack.method_7909();

            if (key.hasProtocol(Protocols.SKELETON))
                return true;

            Tardis found = key.getTardis(player.method_37908(), stack);

            if (found == tardis)
                return true;
        }

        return false;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!(entity instanceof class_3222 player))
            return;

        Tardis tardis = KeyItem.getTardisStatic(world, stack);

        if (tardis == null)
            return;

        KeyItem.hailMary(tardis, stack, player);
    }

    @Override
    public void method_33261(class_1542 entity) {
        class_1297 owner = entity.method_24921();

        if (!(owner instanceof class_3222 player))
            return;

        Tardis tardis = KeyItem.getTardisStatic(entity.method_37908(), entity.method_6983());

        if (tardis == null)
            return;

        tardis.loyalty().subLevel(player, 10);
        tardis.getDesktop().playSoundAtEveryConsole(AITSounds.CLOISTER);
    }

    private static void hailMary(Tardis tardis, class_1799 stack, class_1657 player) {
        if (player.method_7357().method_7904(stack.method_7909()))
            return;

        if (tardis == null) return;

        if (!tardis.stats().hailMary().get())
            return;

        TravelHandler travel = tardis.travel();
        KeyItem keyType = (KeyItem) stack.method_7909().method_8389();

        if (travel.handbrake())
            return;

        if (!keyType.hasProtocol(Protocols.HAIL))
           return;

        if (!tardis.loyalty().get(player).isOf(Loyalty.Type.PILOT))
            return;

        if (player.method_6032() > 4)
            return;

        class_1937 world = player.method_37908();
        // fail silently if destination world is blacklisted
        if (!WorldUtil.getTravelWorlds().contains((class_3218) world))
            return;

        class_2338 pos = player.method_24515();

        CachedDirectedGlobalPos globalPos = CachedDirectedGlobalPos.create((class_3218) world, pos,
                (byte) class_7718.method_45479(player.method_43078()));

        tardis.alarm().enable(ServerAlarmHandler.AlarmType.HAIL_MARY);
        tardis.travel().dematerialize();

        if (travel.getState() != TravelHandlerBase.State.DEMAT)
            return;

        travel.forceDestination(globalPos);
        travel.decreaseFlightTime(500000);
        travel.rematerialize();
        tardis.shields().enable();
        tardis.shields().enableVisuals();
        tardis.removeFuel(4250 + 50 * tardis.travel().instability());


        player.method_6092(new class_1293(class_1294.field_5924, 80, 3));
        player.method_6092(new class_1293(class_1294.field_5912, 6 * 20, 3));
        ((class_3218) world).method_14199(class_2398.field_29644, pos.method_10263(), pos.method_10264(), pos.method_10260(), 10, 1, 1, 1, 1);

        player.method_7357().method_7906(stack.method_7909(), 60 * 20);

        tardis.stats().hailMary().set(false);
        tardis.door().previouslyLocked().set(false);

        // like a sound to show it's been called
        world.method_8396(null, pos, AITSounds.CLOISTER, class_3419.field_15245, 5f, 0.1f);
        world.method_8396(null, pos, class_3417.field_19167, class_3419.field_15245, 5f, 0.1f);
    }

    /*
     * @Override public ActionResult useOnBlock(ItemUsageContext context) { World
     * world = context.getWorld(); BlockPos pos = context.getBlockPos();
     * PlayerEntity player = context.getPlayer(); ItemStack stack =
     * context.getStack();
     *
     * if (world.isClient()) return ActionResult.SUCCESS;
     *
     * if (player == null || !player.isSneaking()) return ActionResult.PASS;
     *
     * if (!(world.getBlockEntity(pos) instanceof ConsoleBlockEntity consoleBlock))
     * return ActionResult.PASS;
     *
     * if (consoleBlock.tardis().isEmpty()) return ActionResult.FAIL;
     *
     * Tardis tardis = consoleBlock.tardis().get();
     *
     * if (tardis.loyalty().get(player).isOf(Loyalty.Type.COMPANION)) {
     * this.link(stack, consoleBlock.tardis().get()); return ActionResult.SUCCESS; }
     *
     * player.sendMessage(Text.translatable("message.ait.tardis.trust_issue",
     * true)); return ActionResult.FAIL; }
     */

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_7909() == AITItems.SKELETON_KEY)
            tooltip.add(class_2561.method_43471("tooltip.ait.skeleton_key").method_27692(class_124.field_1064));
        super.method_7851(stack, world, tooltip, context);
    }
}
