package dev.amble.ait.core.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.tardis.handler.StatsHandler;

public class PersonalityMatrixItem extends class_1792 {
    public PersonalityMatrixItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    public static class_1799 randomize() {
        class_1799 stack = new class_1799(AITItems.PERSONALITY_MATRIX);
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("r", (int) (Math.random() * 256));
        nbt.method_10569("g", (int) (Math.random() * 256));
        nbt.method_10569("b", (int) (Math.random() * 256));
        nbt.method_10582("name", StatsHandler.getRandomName());
        return stack;
    }

    public int[] getColor(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("r") && !nbt.method_10545("g") && !nbt.method_10545("b")) {
            return new int[]{255, 255, 255};
        }
        return new int[]{nbt.method_10550("r"), nbt.method_10550("g"), nbt.method_10550("b")};
    }

    public static int colorToInt(int r, int g, int b) {
        int result = 0;
        result += r;
        result = result << 8;
        result += g;
        result = result << 8;
        result += b;

        return result;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);

        tooltip.add(class_2561.method_43470("Name: " + stack.method_7948().method_10558("name")).method_27692(class_124.field_1078));
        tooltip.add(class_2561.method_43470("#" + colorToInt(getColor(stack)[0], getColor(stack)[1], getColor(stack)[2]))
                .method_27692(class_124.field_1080));
    }
}
