package dev.amble.ait.core.item;

import static dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase.State.LANDED;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7718;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.DirectionControl;
import dev.amble.ait.core.tardis.handler.travel.TravelUtil;
import dev.amble.ait.core.world.TardisServerWorld;

public class RemoteItem extends LinkableItem {

    public RemoteItem(class_1793 settings) {
        super(settings, true);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 itemStack = context.method_8041();

        if (player == null)
            return class_1269.field_5811;

        if (!(world instanceof class_3218 serverWorld))
            return class_1269.field_5811;

        Tardis tardis = RemoteItem.getTardisStatic(world, itemStack);

        if (tardis == null)
            return class_1269.field_5814;

        if (player.method_5715()) {
            if (!tardis.travel().inFlight()) {
                if (!tardis.fuel().hasPower()) {
                    tardis.fuel().enablePower();
                    player.method_7353(class_2561.method_43470("TARDIS Powering Up..."), true);
                    tardis.getExterior().playSound(AITSounds.POWERUP, class_3419.field_15245);
                    world.method_45447(null, pos, AITSounds.REMOTE, class_3419.field_15245);
                } else {
                    tardis.fuel().disablePower();
                    player.method_7353(class_2561.method_43470("TARDIS Powering Down..."), true);
                    tardis.getExterior().playSound(AITSounds.SHUTDOWN, class_3419.field_15245);
                    world.method_45447(null, pos, AITSounds.REMOTE, class_3419.field_15245);
                }
            } else if (tardis.travel().inFlight() || !tardis.travel().isLanded()) {
                player.method_7353(class_2561.method_43470("TARDIS in flight. Power Switch Disabled."), true);
            }
            return class_1269.field_5811;
        }

        if (tardis.getFuel() <= 0)
            player.method_43496(class_2561.method_43471("message.ait.remoteitem.warning1"));

        if (tardis.isRefueling())
            player.method_43496(class_2561.method_43471("message.ait.remoteitem.cancel.refuel"));

        //It was dematting before anyway so as a lazy fix its a feature now!!
        //player.sendMessage(Text.translatable("message.ait.remoteitem.warning2"));

        // Check if the Tardis is already present at this location before moving
        // it there

        CachedDirectedGlobalPos currentPosition = tardis.travel().position();

        if (currentPosition.getPos().equals(pos))
            return class_1269.field_5814;

        if (!TardisServerWorld.isTardisDimension((class_3218) world)) {
            world.method_45447(null, pos, AITSounds.REMOTE, class_3419.field_15245);

            class_2338 temp = pos.method_10084();

            if (world.method_8320(pos).method_45474())
                temp = pos;
                if (tardis.fuel().hasPower()) {
                    tardis.travel().speed(tardis.travel().maxSpeed().get());

                    TravelUtil.travelTo(tardis, CachedDirectedGlobalPos.create(serverWorld, temp, DirectionControl
                            .getGeneralizedRotation(class_7718.method_45479(player.method_43078()))));
                } else {
                    player.method_7353(class_2561.method_43470("Takeoff Failed, TARDIS powered off..."), true);
                }
            } else {
            world.method_8396(null, pos, class_3417.field_18311.comp_349(), class_3419.field_15245, 1F,
                    0.2F);
            player.method_7353(class_2561.method_43471("message.ait.remoteitem.warning3"), true);
        }

        return class_1269.field_5811;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);

        Tardis tardis = RemoteItem.getTardisStatic(world, stack);

        if (tardis == null)
            return;

        if (tardis.travel().getState() != LANDED)
            tooltip.add(class_2561.method_43470("→ " + tardis.travel().getDurationAsPercentage() + "%")
                    .method_27692(class_124.field_1065));
    }
}
