package dev.amble.ait.core.item;

import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;

public class RiftScannerItem extends class_1792 {
    private static final int MAX_ITERATIONS = 32;

    public RiftScannerItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!(world instanceof class_3218 serverWorld))
            return class_1271.method_22430(user.method_5998(hand));

        if (TardisServerWorld.isTardisDimension(serverWorld))
            return class_1271.method_22431(user.method_5998(hand));

        user.method_7357().method_7906(this, 100);
        findNearestRift(serverWorld, new class_1923(user.method_24515()), (chunk) -> setTarget(user.method_5998(hand), chunk));

        user.method_7353(class_2561.method_43471("riftchunk.ait.tracking"), true);
        return class_1271.method_22427(user.method_5998(hand));
    }

    /**
     * Searches for a target block with artron levels > 0 within a range.
     *
     * @param world
     *            The world object.
     * @param source
     *            The current chunk
     */
    public static void findNearestRift(class_3218 world, class_1923 source, Consumer<class_1923> found) {
        int steps = 1;
        RiftChunkManager manager = RiftChunkManager.getInstance(world);

        for (int i = 0; i < MAX_ITERATIONS; i++) {
            if (steps % 2 != 0) {
                if (trySearch(manager, steps, source, class_2350.field_11034, found))
                    return;

                if (trySearch(manager, steps, source, class_2350.field_11035, found))
                    return;
            } else {
                if (trySearch(manager, steps, source, class_2350.field_11039, found))
                    return;

                if (trySearch(manager, steps, source, class_2350.field_11043, found))
                    return;
            }

            steps++;
        }
    }

    private static boolean trySearch(RiftChunkManager manager, int limit, class_1923 source, class_2350 direction, Consumer<class_1923> found) {
        for (int b = 0; b <= limit; b++) {
            source = getChunkInDirection(source, direction);

            if (isConsumable(manager, source)) {
                found.accept(source);
                return true;
            }
        }

        return false;
    }

    private static boolean isConsumable(RiftChunkManager manager, class_1923 pos) {
        return manager.isRiftChunk(pos) && manager.getArtron(pos) >= 250;
    }

    private static class_1923 getChunkInDirection(class_1923 pos, class_2350 dir) {
        return new class_1923(pos.field_9181 + (dir.method_10148()), pos.field_9180 + (dir.method_10165()));
    }

    private static void setTarget(class_1799 stack, class_1923 pos) {
        class_2487 nbt = stack.method_7948();

        nbt.method_10569("X", pos.field_9181);
        nbt.method_10569("Z", pos.field_9180);
    }

    public static class_1923 getTarget(class_1799 stack) {
        class_2487 nbt = stack.method_7948();

        if (!(nbt.method_10545("X") && nbt.method_10545("Z")))
            return class_1923.field_35107;

        return new class_1923(nbt.method_10550("X"), nbt.method_10550("Z"));
    }
}
