package dev.amble.ait.core.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.tardis.Tardis;

// todo fix so many issues with having more than one of this item
public class SiegeTardisItem extends LinkableItem {

    public static final String CURRENT_TEXTURE_KEY = "siege_current_texture";

    public SiegeTardisItem(class_1793 settings) {
        super(settings.method_7889(1), "tardis-uuid", true);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);

        if (world.method_8608())
            return;

        Tardis tardis = this.getTardis(world, stack);

        if (tardis == null) {
            stack.method_7939(0);
            return;
        }

        if (!tardis.siege().isActive()) {
            tardis.setSiegeBeingHeld(null);
            return;
        }

        if (entity instanceof class_3222 player)
            tardis.siege().setSiegeBeingHeld(player.method_5667());

        tardis.travel().forcePosition(fromEntity(entity));

        if (!tardis.isSiegeBeingHeld()) {
            tardis.setSiegeBeingHeld(entity.method_5667());
        }
    }


    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() != class_1268.field_5808 || context.method_8036() == null)
            return class_1269.field_5811;

        context.method_8036().method_31548().method_5447(context.method_8036().method_31548().field_7545, class_1802.field_8162.method_7854());

        context.method_8041().method_7934(1);

        if (context.method_8045().method_8608())
            return class_1269.field_5812;

        Tardis tardis = this.getTardis(context.method_8045(), context.method_8041());

        if (tardis == null)
            return class_1269.field_21466;

        if (!tardis.siege().isActive()) {
            tardis.setSiegeBeingHeld(null);
            return class_1269.field_5812;
        }

        placeTardis(tardis, fromItemContext(context));
        return super.method_7884(context);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 tag = stack.method_7948();
        String text = tag.method_10545("tardis-uuid")
                ? tag.method_25926("tardis-uuid").toString().substring(0, 8)
                : class_2561.method_43471("tooltip.ait.remoteitem.notardis").getString();

        tooltip.add(class_2561.method_43470("→ " + text).method_27692(class_124.field_1078));
    }

    public static CachedDirectedGlobalPos fromItemContext(class_1838 context) {
        return CachedDirectedGlobalPos.create((class_3218) context.method_8045(),
                context.method_8037().method_10093(context.method_8038()), (byte) 0);
    }

    public static CachedDirectedGlobalPos fromEntity(class_1297 entity) {
        return CachedDirectedGlobalPos.create((class_3218) entity.method_37908(), class_2338.method_49638(entity.method_19538()),
                (byte) 0);
    }

    public static void pickupTardis(Tardis tardis, class_3222 player) {
        if (tardis.travel().handbrake())
            return;

        tardis.travel().deleteExterior();
        tardis.siege().setSiegeBeingHeld(player.method_5667());
        player.method_31548().method_7394(create(tardis));
        player.method_31548().method_5431();
    }

    public static void placeTardis(Tardis tardis, CachedDirectedGlobalPos pos) {
        tardis.travel().forcePosition(pos);
        tardis.travel().placeExterior(false);
        tardis.setSiegeBeingHeld(null);
    }

    public static class_1799 create(Tardis tardis) {
        class_1799 stack = new class_1799(AITItems.SIEGE_ITEM);
        stack.method_7939(1);

        SiegeTardisItem.linkStatic(stack, tardis);
        return stack;
    }
}
