package dev.amble.ait.core.item;

import static dev.amble.ait.client.util.TooltipUtil.addShiftHiddenTooltip;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedGlobalPos;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.tardis.control.impl.DirectionControl;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Waypoint;

public class WaypointItem extends class_1792 implements class_1768 {

    public static final int field_30872 = 16777215;
    public static final String POS_KEY = "pos";

    public WaypointItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);

        addShiftHiddenTooltip(stack, tooltip, tooltips -> {
            class_2487 main = stack.method_7948();

            if (!main.method_10545(POS_KEY))
                return;

            class_2487 nbt = main.method_10562(POS_KEY);
            DirectedGlobalPos globalPos = DirectedGlobalPos.fromNbt(nbt);

            class_2338 pos = globalPos.getPos();
            String dir = DirectionControl.rotationToDirection(globalPos.getRotation());
            class_5321<class_1937> dimension = globalPos.getDimension();

            tooltips.add(class_2561.method_43471("waypoint.position.tooltip")
                    .method_10852(class_2561.method_43470(" > " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260()))
                    .method_27692(class_124.field_1078));

            tooltips.add(class_2561.method_43471("waypoint.direction.tooltip")
                    .method_10852(class_2561.method_43470(" > " + dir.toUpperCase()))
                    .method_27692(class_124.field_1078));

            tooltips.add(class_2561.method_43471("waypoint.dimension.tooltip")
                    .method_10852(class_2561.method_43470(" > ").method_10852(WorldUtil.worldText(dimension, false)))
                    .method_27692(class_124.field_1078));
        });
    }

    @Override
    public int method_7800(class_1799 stack) {
        class_2487 nbt = stack.method_7941(field_30871);

        if (nbt != null && nbt.method_10573(field_30873, class_2520.field_33263))
            return nbt.method_10550(field_30873);

        return field_30872; // white
    }

    public static class_1799 create(Waypoint pos) {
        class_1799 stack = new class_1799(AITItems.WAYPOINT_CARTRIDGE);
        if (pos == null) return stack;

        setPos(stack, pos.getPos());

        if (pos.hasName())
            stack.method_7977(class_2561.method_43470(pos.name()));

        return stack;
    }

    public static CachedDirectedGlobalPos getPos(class_1799 stack) {
        class_2487 nbt = stack.method_7948();

        if (!nbt.method_10545(POS_KEY))
            return null;

        CachedDirectedGlobalPos cached = CachedDirectedGlobalPos.fromNbt(nbt.method_10562(POS_KEY));
        if (cached.getWorld() instanceof TardisServerWorld) {
            cached = CachedDirectedGlobalPos.create(TardisServerWorld.field_25179, cached.getPos(), cached.getRotation());
        }

        return cached;
    }

    public static void setPos(class_1799 stack, DirectedGlobalPos pos) {
        class_2487 nbt = stack.method_7948();
        if (pos == null) return;
        CachedDirectedGlobalPos cached = CachedDirectedGlobalPos.create(pos.getDimension(), pos.getPos(), pos.getRotation());
        if (cached.getWorld() instanceof TardisServerWorld) {
            cached = CachedDirectedGlobalPos.create(TardisServerWorld.field_25179, cached.getPos(), cached.getRotation());
        }
        nbt.method_10566(POS_KEY, cached.toNbt());
    }
}
