package dev.amble.ait.core.item.blueprint;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import dev.amble.ait.core.util.StackUtil;

public class Blueprint {
    private final BlueprintSchema source;
    private final List<class_1799> requirements;
    private final List<class_1799> initialRequirements;

    public Blueprint(BlueprintSchema source) {
        this.source = source;

        this.initialRequirements = source.inputs().toStacks();
        this.requirements = StackUtil.cloneList(initialRequirements);
    }

    public Blueprint(class_2487 nbt) {
        this(BlueprintRegistry.getInstance().get(new class_2960(nbt.method_10558("id"))));

        this.requirements.clear();
        this.fromNbt(nbt);
    }

    /**
     * attempts to resolve a requirement from the list of requirements by removing it if this stack is a valid requirement
     * @param stack the stack to resolve
     * @return true if the stack was a valid requirement and was removed, false otherwise
     */
    public boolean tryAdd(class_1799 stack) {
        for (class_1799 requirement : requirements) {
            if (class_1799.method_7984(requirement, stack)) {
                // now we need to check if the stack has the same amount of items

                int deducted = Math.min(requirement.method_7947(), stack.method_7947());
                requirement.method_7934(deducted);
                stack.method_7934(deducted);

                if (requirement.method_7960())
                    requirements.remove(requirement);

                return true;
            }
        }

        return false;
    }

    public int getCountLeftFor(class_1799 stack) {
        for (class_1799 requirement : requirements) {
            if (class_1799.method_7984(requirement, stack)) {
                return requirement.method_7947();
            }
        }

        return 0;
    }

    public boolean isComplete() {
        return requirements.isEmpty();
    }

    public class_1799 getOutput() {
        return source.output().method_7972();
    }

    public Optional<class_1799> tryCraft() {
        if (!isComplete())
            return Optional.empty();

        return Optional.of(getOutput());
    }

    public List<class_1799> getRequirements() {
        return requirements;
    }

    /**
     * @return All the items that were inserted into the fabricator
     */
    public List<class_1799> getInsertedItems() {
        // all the items missing from the initial requirements
        List<class_1799> inserted = new ArrayList<>(initialRequirements);

        for (class_1799 j : requirements) {
            inserted.stream()
                    .filter(i -> class_1799.method_7984(i, j))
                    .forEach(i -> i.method_7934(j.method_7947()));
        }

        return inserted;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", source.id().toString());

        class_2499 list = new class_2499();
        for (class_1799 stack : requirements) {
            list.add(stack.method_7953(new class_2487()));
        }
        nbt.method_10566("requirements", list);

        return nbt;
    }
    protected class_2487 fromNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("requirements", 10);
        for (int i = 0; i < list.size(); i++) {
            requirements.add(class_1799.method_7915(list.method_10602(i)));
        }

        return nbt;
    }

    public BlueprintSchema getSource() {
        return source;
    }
}
