package dev.amble.ait.core.item.blueprint;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.api.Identifiable;
import dev.amble.ait.AITMod;

public record BlueprintSchema(class_2960 id, class_2561 text, InputList inputs, class_1799 output) implements Identifiable {
    public static Codec<BlueprintSchema> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_1799.field_24671.fieldOf("output").forGetter(BlueprintSchema::output),
            InputList.CODEC.fieldOf("inputs").forGetter(BlueprintSchema::inputs)
    ).apply(instance, BlueprintSchema::new));

    public BlueprintSchema(class_1799 output, InputList inputs) {
        this(class_7923.field_41178.method_10221(output.method_7909()), class_2561.method_43471(output.method_7922()), inputs, output);
    }

    public Blueprint create() {
        return new Blueprint(this);
    }

    @Override
    public String toString() {
        return "BlueprintSchema{" +
                "id=" + id +
                ", text=" + text +
                ", inputs=" + inputs +
                ", output=" + output +
                '}';
    }

    public static BlueprintSchema fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static BlueprintSchema fromJson(JsonObject json) {
        AtomicReference<BlueprintSchema> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(planet -> created.set(planet.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack blueprint: {}", err);
        });

        return created.get();
    }

    public static class Input {
        public static Codec<Input> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                class_2960.field_25139.fieldOf("item").forGetter(input -> class_7923.field_41178.method_10221(input.item)),
                Codec.INT.fieldOf("minCount").forGetter(Input::minimum),
                Codec.INT.fieldOf("maxCount").forGetter(Input::maximum)
        ).apply(instance, Input::new));

        private final class_1792 item;
        private final int maxCount;
        private final int minCount;

        public Input(class_1792 item, int minCount, int maxCount) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }
        public Input(class_1792 item, int count) {
            this(item, count, count);
        }
        public Input(class_1792 item) {
            this(item, 1);
        }
        public Input(class_1799 stack) {
            this(stack.method_7909(), stack.method_7947());
        }

        private Input(class_2960 item, Integer min, Integer max) {
            this(class_7923.field_41178.method_10223(item), min, max);
        }

        public int minimum() {
            return minCount;
        }
        public int maximum() {
            return maxCount;
        }

        /**
         * Converts this input to a stack with a random count between minCount and maxCount
         */
        public class_1799 toStack() {
            return new class_1799(item, minCount + (int) (Math.random() * (maxCount - minCount)));
        }

        public class_1799 maxCountStack() {
            return new class_1799(item, maxCount);
        }

        @Override
        public String toString() {
            return "Input{" +
                    "item=" + item +
                    ", minCount=" + minCount +
                    ", maxCount=" + maxCount +
                    '}';
        }

        public class_2561 text() {
            class_2561 countText = minCount == maxCount ? class_2561.method_43470(String.valueOf(minCount)) : class_2561.method_43470(minCount + "-" + maxCount);

            return class_2564.method_10885(class_2561.method_43471(item.method_7876()))
                    .method_27693(" x")
                    .method_10852(countText);
        }
    }
    public static class InputList extends ArrayList<Input> {
        public static Codec<InputList> CODEC = Input.CODEC.listOf().flatXmap(l -> {
            InputList list = new InputList();
            list.addAll(l);
            return DataResult.success(list);
        }, DataResult::success);

        public InputList() {
            super();
        }
        public InputList(Input... inputs) {
            super(List.of(inputs));
        }
        public InputList(class_1799... stacks) {
            super();
            for (class_1799 stack : stacks) {
                add(new Input(stack));
            }
        }
        public List<class_1799> toStacks() {
            List<class_1799> stacks = new ArrayList<>();
            for (Input input : this) {
                stacks.add(input.toStack());
            }
            return stacks;
        }
    }
}
