package dev.amble.ait.core.item.sonic;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2286;
import net.minecraft.class_2309;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2462;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.data.schema.sonic.SonicSchema;

public class InteractionSonicMode extends SonicMode {

    protected InteractionSonicMode(int index) {
        super(index);
    }

    @Override
    public class_2561 text() {
        return class_2561.method_43471("sonic.ait.mode.interaction").method_27695(class_124.field_1060, class_124.field_1067);
    }

    @Override
    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
        if (!(world instanceof class_3218 serverWorld) || ticks % 10 != 0)
            return;

        this.process(serverWorld, user, ticks);
    }

    private void process(class_3218 world, class_1309 user, int ticks) {
        class_239 hitResult = SonicMode.getHitResultForOutline(user);

        SonicMode.checkSonicWoodAdvancementConditions(world, user, hitResult);

        if (hitResult instanceof class_3965 blockHit) {
            this.interactBlock(blockHit.method_17777(), world, user, ticks, blockHit);
        }
    }

    private void interactBlock(class_2338 pos, class_3218 world, class_1309 user, int ticks, class_3965 blockHit) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();

        if (!state.method_26164(AITTags.Blocks.SONIC_INTERACTABLE)) return;

        if (block == class_2246.field_9973 && state.method_28498(class_2741.field_12537)) {
            boolean isOpen = state.method_11654(class_2741.field_12537);
            world.method_8652(pos, state.method_11657(class_2741.field_12537, !isOpen), 3);
            world.method_33596(user, class_5712.field_28174, pos);
            return;
        }

        if (block == class_2246.field_10453 && state.method_28498(class_2741.field_12537)) {
            boolean isOpen = state.method_11654(class_2741.field_12537);
            world.method_8652(pos, state.method_11657(class_2741.field_12537, !isOpen), 3);
            world.method_33596(user, class_5712.field_28174, pos);
            return;
        }

        if (block instanceof class_2462 && state.method_28498(class_2741.field_12494)) {
            world.method_8652(pos, state.method_28493(class_2741.field_12494), 3);
            world.method_33596(user, class_5712.field_28733, pos);
            return;
        }

        if (block instanceof class_2286 && state.method_28498(class_2741.field_12534)) {
            world.method_8652(pos, state.method_28493(class_2741.field_12534), 3);
            world.method_33596(user, class_5712.field_28733, pos);
            return;
        }

        if (block instanceof class_2309 && state.method_28498(class_2741.field_12501)) {
            world.method_8652(pos, state.method_28493(class_2741.field_12501), 3);
            world.method_33596(user, class_5712.field_28733, pos);
            return;
        }

        if (user instanceof class_1657 player && block instanceof class_2269 button) {
            button.method_9534(state, world, pos, player, player.method_6058(), blockHit);
            return;
        }
    }

    @Override
    public int maxTime() {
        return 5 * 60 * 20; // 5 minutes
    }

    @Override
    public class_2960 model(SonicSchema.Models models) {
        return models.interaction();
    }
}
