package dev.amble.ait.core.item.sonic;

import dev.amble.lib.api.ICantBreak;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.entities.RiftEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.util.MonitorUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.landing.LandingPadRegion;
import dev.amble.ait.data.landing.LandingPadSpot;
import dev.amble.ait.data.schema.sonic.SonicSchema;

public class ScanningSonicMode extends SonicMode {
    private static final class_2561 RIFT_FOUND = class_2561.method_43471("message.ait.sonic.riftfound").method_27692(class_124.field_1075)
            .method_27692(class_124.field_1067);
    private static final class_2561 RIFT_NOT_FOUND = class_2561.method_43471("message.ait.sonic.riftnotfound").method_27692(class_124.field_1075)
            .method_27692(class_124.field_1067);

    protected ScanningSonicMode(int index) {
        super(index);
    }

    @Override
    public class_2561 text() {
        return class_2561.method_43471("sonic.ait.mode.scanning").method_27695(class_124.field_1054, class_124.field_1067);
    }

    @Override
    public int maxTime() {
        return 5 * 60 * 20;
    }

    @Override
    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
        if (!(world instanceof class_3218 serverWorld) || !(user instanceof class_1657 player) || ticks % 10 != 0)
            return;

        this.process(stack, world, player);
    }



    public boolean process(class_1799 stack, class_1937 world, class_1657 user) {
        class_239 hitResult = SonicMode.getHitResult(user);

        boolean isMainHand = user.method_6047().method_7909() == stack.method_7909();

        if (isMainHand) {
            SonicMode.checkSonicWoodAdvancementConditions(world, user, hitResult);

            if (hitResult instanceof class_3965 blockHit && !world.method_8320(blockHit.method_17777()).method_26215()) {
                return this.scanBlocks(stack, world, user, blockHit.method_17777());
            }

            if (hitResult instanceof class_3966 entityHit && !(entityHit.method_17782() instanceof RiftEntity)) {
                return this.scanEntities(stack, world, user, entityHit.method_17782());
            }
        }

        return this.scanRegion(stack, world, user, class_2338.method_49638(hitResult.method_17784()));
    }



    public boolean scanBlocks(class_1799 stack, class_1937 world, class_1657 user, class_2338 pos) {
        if (world.method_8608() || user == null)
            return true;

        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        Tardis tardis = SonicItem.getTardisStatic(world, stack);

        String blastRes = String.format("%.2f", block.method_9520());

        if (tardis != null && state.method_26164(AITTags.Blocks.SONIC_CAN_LOCATE)) {
            class_2338 tPos = tardis.travel().position().getPos();
            class_1937 tardisWorld = tardis.travel().position().getWorld();
            String dimensionText = MonitorUtil.truncateDimensionName(WorldUtil.worldText(tardisWorld.method_27983()).getString(), 20);

            class_2561 coordinatesMessage = class_2561.method_43469("item.sonic.scanning.locator_message.coordinates", tPos.method_10263(), tPos.method_10264(), tPos.method_10260());
            class_2561 fullMessage = class_2561.method_43469("item.sonic.scanning.locator_message.title", dimensionText).method_27693("\n").method_10852(coordinatesMessage);

            // Output looks like:
            // TARDIS Location: {DIMENSION}
            // Coordinates: {X} {Y} {Z}
            user.method_43496(fullMessage);
        }

        LandingPadRegion region = LandingPadManager.getInstance((class_3218) world).getRegionAt(pos);
        if (region != null) {
            if (world.method_8320(pos).method_26215()) return true;

            boolean wasSpotCreated = modifyRegion(null, (class_3218) world, pos.method_10084(), user, stack, region);

            float pitch = wasSpotCreated ? 1.1f : 0.75f;
            world.method_8396(null, pos, AITSounds.SONIC_SWITCH, class_3419.field_15248, 1f, pitch);

            return true;
        }

        String toolRequirement = "item.sonic.scanning.any_tool";
        if (block instanceof ICantBreak) {
            toolRequirement = "item.sonic.scanning.cant_break";
        } else {
            if (state.method_26164(class_3481.field_33717)) {
                toolRequirement = "item.sonic.scanning.diamond_tool";
            } else if (state.method_26164(class_3481.field_33718)) {
                toolRequirement = "item.sonic.scanning.iron_tool";
            } else if (state.method_26164(class_3481.field_33719)) {
                toolRequirement = "item.sonic.scanning.stone_tool";
            } else if (!block.method_9564().method_29291()) {
                toolRequirement = "item.sonic.scanning.no_tool";
            }
        }

        class_2561 message = class_2561.method_43470("\uD83D\uDD25: " + blastRes + " ⛏: ").method_10852(class_2561.method_43471(toolRequirement)).method_27692(class_124.field_1054)
                .method_27692(class_124.field_1065);
        user.method_7353(message, true);

        return true;
    }



    public boolean scanRegion(class_1799 stack, class_1937 world, class_1657 user, class_2338 pos) {
        if (world.method_8608())
            return true;

        if (user == null)
            return false;

        if (!TardisServerWorld.isTardisDimension(world)) {
            sendRiftInfo(null, (class_3218) world, pos, user, stack);
            return true;
        }

        Tardis tardis = SonicItem.getTardisStatic(world, stack);

        if (tardis == null)
            return false;

        if (TardisServerWorld.isTardisDimension(world)) {
            sendTardisInfo(tardis, (class_3218) world, pos, user, stack);
            return true;
        }

        return false;
    }

    public boolean scanEntities(class_1799 stack, class_1937 world, class_1657 user, class_1297 entity) {
        if (world.method_8608())
            return true;

        if (user == null)
            return false;

        if (entity instanceof class_1309) {
            String health = String.valueOf(((class_1309) entity).method_6032());
            String maxhealth = String.valueOf(((class_1309) entity).method_6063());
            user.method_7353(class_2561.method_43470("♥:").method_27693(health).method_27693("/").method_27693(maxhealth).method_27692(class_124.field_1054), true);
        }

        return false;
    }

    private static boolean modifyRegion(Tardis tardis, class_3218 world, class_2338 pos, class_1657 player, class_1799 stack, LandingPadRegion region) {
        LandingPadSpot spot = region.getSpotAt(pos).orElse(null);

        if (spot == null) {
            addSpot(region, pos);

            syncRegion(world, pos);
            return true;
        }

        removeSpot(region, pos);
        syncRegion(world, pos);

        return false;
    }
    private static void addSpot(LandingPadRegion region, class_2338 pos) {
        region.createSpotAt(pos);
    }
    private static void removeSpot(LandingPadRegion region, class_2338 pos) {
        region.removeSpotAt(pos);
    }
    private static void syncRegion(class_3218 world, class_2338 pos) {
        LandingPadManager.Network.syncTracked(LandingPadManager.Network.Action.ADD, world, new class_1923(pos));
    }

    private static void sendRiftInfo(Tardis tardis, class_3218 world, class_2338 pos, class_1657 player, class_1799 stack) {
        boolean isRift = RiftChunkManager.isRiftChunk(world, pos);

        player.method_7353(isRift ? RIFT_FOUND : RIFT_NOT_FOUND, true);

        if (!isRift) return;

        int artronValue = (int) RiftChunkManager.getInstance(world).getArtron(new class_1923(pos));
        player.method_43496(
                class_2561.method_43469("message.ait.artron_units", artronValue)
                        .method_27692(class_124.field_1065)
        );
    }
    private static void sendTardisInfo(Tardis tardis, class_3218 world, class_2338 pos, class_1657 player, class_1799 stack) {
        if (tardis == null)
            return;

        if (tardis.crash().isUnstable() || tardis.crash().isToxic()) {
            player.method_7353(class_2561.method_43469("message.ait.sonic.repairtime", tardis.crash().getRepairTicks())
                    .method_27695(class_124.field_1079, class_124.field_1056), true);
            return;
        }

        player.method_7353(
                class_2561.method_43469("message.ait.artron_units", tardis.fuel().getCurrentFuel()).method_27692(class_124.field_1065), true);
    }

    @Override
    public class_2960 model(SonicSchema.Models models) {
        return models.scanning();
    }
}
