package dev.amble.ait.core.item.sonic;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedGlobalPos;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.sonic.SonicSchema;

public class TardisSonicMode extends SonicMode {

    protected TardisSonicMode(int index) {
        super(index);
    }

    @Override
    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
        if (!(world instanceof class_3218 serverWorld) || !(user instanceof class_1657 player) || ticks % 10 != 0)
            return;

        this.process(stack, world, player);
    }

    public boolean process(class_1799 stack, class_1937 world, class_1657 user) {
        if (!(user instanceof class_3222 player))
            return false;

        Tardis tardis = SonicItem.getTardisStatic(world, stack);

        if (tardis == null)
            return false;

        boolean isMainHand = user.method_6047().method_7909() == stack.method_7909();
        if (isMainHand) {
            class_239 hitResult = SonicMode.getHitResult(user, 2);

            // summon to selected block
            return this.interactBlock(stack, world, player, class_2338.method_49638(hitResult.method_17784()));
        }
        boolean isLookingUp = user.method_36455() < 0;

        if (isLookingUp) {
            // send tardis to flight and disengage handbrake
            tardis.travel().handbrake(false);
            tardis.travel().dematerialize();

            player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.flight"), true);

            return true;
        }

        // turn on handbrake and engage refueling
        tardis.travel().handbrake(true);
        tardis.fuel().refueling().set(true);

        player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.refuel"), true);

        return true;
    }

    private boolean interactBlock(class_1799 stack, class_1937 world, class_3222 player, class_2338 pos) {
        // summon tardis to block
        Tardis tardis = SonicItem.getTardisStatic(world, stack);

        if (tardis == null)
            return false;

        // fail silently if in tardis dim
        if (TardisServerWorld.isTardisDimension(world)) return false;

        // get position of player
        CachedDirectedGlobalPos targetPos = CachedDirectedGlobalPos.create(player.method_51469().method_27983(), pos, DirectedGlobalPos.getGeneralizedRotation(player.method_5755()));

        if (!tardis.subsystems().get(SubSystem.Id.STABILISERS).isUsable()) {
            player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.does_not_have_stabilisers"), true);
            return false;
        }

        // check if player is within range of and in same world as TARDIS
        class_1937 tardisWorld = tardis.travel().position().getWorld();
        boolean inSameWorld = player.method_37908().equals(tardisWorld);
        boolean isNearTardis = TardisUtil.isNearTardis(player, tardis, 256);
        double distance = TardisUtil.distanceFromTardis(player, tardis);

        if (!tardis.fuel().hasPower()){
            player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.does_not_have_power"), true);
            return false;
        }

        if (tardis.fuel().getCurrentFuel() <= TardisUtil.estimatedFuelCost(player, tardis, distance)) {
            player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.insufficient_fuel"), true);
            return false;
        }

        if (!inSameWorld || !isNearTardis) {
            player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.is_not_in_range"), true);
            return false;
        }

        tardis.travel().destination(targetPos);
        tardis.travel().autopilot(true);
        tardis.travel().dematerialize();

        // inform player
        player.method_7353(class_2561.method_43471("sonic.ait.mode.tardis.location_summon"), true);

        return true;
    }

    @Override
    public class_2561 text() {
        return class_2561.method_43471("sonic.ait.mode.tardis").method_27695(class_124.field_1078, class_124.field_1067);
    }

    @Override
    public int maxTime() {
        return 2 * 20;
    }

    @Override
    public class_2960 model(SonicSchema.Models models) {
        return models.tardis();
    }
}
