package dev.amble.ait.core.likes;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5699;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.api.Identifiable;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.ServerTardis;

public record ItemOpinion(class_2960 id, class_1799 stack, int cost, int loyalty) implements Identifiable, Opinion {
    public static final Codec<ItemOpinion> CODEC = class_5699.method_42114(RecordCodecBuilder.create(instance -> instance.group(
                    class_2960.field_25139.fieldOf("id").forGetter(ItemOpinion::id),
                    class_1799.field_24671.fieldOf("stack").forGetter(ItemOpinion::stack),
                    Codec.INT.optionalFieldOf("cost", -1).forGetter(ItemOpinion::cost),
                    Codec.INT.fieldOf("loyalty").forGetter(ItemOpinion::loyalty))
            .apply(instance, ItemOpinion::new)));


    public ItemOpinion {
        if (cost < 0) {
            cost = loyalty * 10;
        }
    }

    public ItemOpinion(class_2960 id, class_1799 stack, int loyalty) {
        this(id, stack, loyalty * 10, loyalty);
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    @Override
    public void apply(ServerTardis tardis, class_3222 target) {
        Opinion.super.apply(tardis, target);

        target.method_31548().method_7391().method_7934(this.stack().method_7947()); // assume its in the main hand
        target.method_7255(-this.cost);
    }

    @Override
    public Type type() {
        return Type.ITEM;
    }

    @Override
    public String toString() {
        return "ItemOpinion{" +
                "id=" + id +
                ", stack=" + stack +
                ", cost=" + cost +
                ", loyalty=" + loyalty +
                '}';
    }

    public static ItemOpinion fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static ItemOpinion fromJson(JsonObject json) {
        AtomicReference<ItemOpinion> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(var -> created.set(var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack item opinion: {}", err);
        });

        return created.get();
    }
}
