package dev.amble.ait.core.likes;

import java.util.Optional;

import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3264;
import dev.amble.ait.AITMod;

public class ItemOpinionRegistry extends SimpleDatapackRegistry<ItemOpinion> {
    private static final ItemOpinionRegistry instance = new ItemOpinionRegistry();


    public ItemOpinionRegistry() {
        super(ItemOpinion::fromInputStream, ItemOpinion.CODEC, "opinion_item", "opinion/item", true, AITMod.MOD_ID);
    }

    public static ItemOpinion LIKES_ENDER_EYE;

    @Override
    protected void defaults() {
        LIKES_ENDER_EYE = register(new ItemOpinion(AITMod.id("likes_ender_eye"), class_1802.field_8449.method_7854(), 10));
    }

    @Override
    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(this);
    }

    @Override
    public ItemOpinion fallback() {
        return LIKES_ENDER_EYE;
    }

    public Optional<ItemOpinion> get(class_1799 stack) {
        return REGISTRY.values().stream().filter(opinion -> opinion.stack().equals(stack)).findFirst();
    }
    public Optional<ItemOpinion> get(class_1792 item) {
        return REGISTRY.values().stream().filter(opinion -> opinion.stack().method_7909().equals(item)).findFirst();
    }

    public static ItemOpinionRegistry getInstance() {
        return instance;
    }
}
