package dev.amble.ait.core.likes;

import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import dev.amble.lib.api.Identifiable;
import dev.amble.ait.core.tardis.ServerTardis;

public interface Opinion extends Identifiable {
    int loyalty();
    Type type();

    default boolean likes() {
        return loyalty() > 0;
    }
    default void apply(ServerTardis tardis, class_3222 target) {
        tardis.loyalty().addLevel(target, loyalty());
    }

    enum Type {
        ITEM {
            @Override
            public Opinion get(class_2960 id) {
                return ItemOpinionRegistry.getInstance().get(id);
            }
        },
        ;

        public abstract Opinion get(class_2960 id);
    };

    static Optional<Opinion> find(class_2960 id) {
        for (Type type : Type.values()) {
            Opinion opinion = type.get(id);
            if (opinion != null) {
                return Optional.of(opinion);
            }
        }

        return Optional.empty();
    }
}
