package dev.amble.ait.core.lock;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7924;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.register.unlockable.Unlockable;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.Loyalty;

public record LockedDimension(class_2960 dimension, class_1799 stack) implements Unlockable, Nameable {
    public static final Codec<LockedDimension> CODEC = class_5699.method_42114(RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("dimension").forGetter(LockedDimension::dimension),
            class_1799.field_24671.fieldOf("stack").forGetter(LockedDimension::stack))
            .apply(instance, LockedDimension::new)));

    @Override
    public class_2960 id() {
        return this.dimension();
    }

    public static LockedDimension fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static LockedDimension fromJson(JsonObject json) {
        AtomicReference<LockedDimension> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(planet -> created.set(planet.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack locked dim: {}", err);
        });

        return created.get();
    }

    @Override
    public UnlockType unlockType() {
        return UnlockType.DIMENSION;
    }

    @Override
    public Optional<Loyalty> requirement() {
        return Optional.of(Loyalty.fromLevel(100));
    }

    @Override
    public String name() {
        return this.text().getString();
    }

    @Override
    public class_2561 text() {
        return WorldUtil.worldText(class_5321.method_29179(class_7924.field_41223, this.dimension()), false);
    }
}
