
package dev.amble.ait.core.loot;

import java.util.function.Supplier;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import dev.amble.ait.core.item.blueprint.BlueprintItem;
import dev.amble.ait.core.item.blueprint.BlueprintRegistry;
import dev.amble.ait.core.item.blueprint.BlueprintSchema;

public class SetBlueprintLootFunction extends class_120 {
    private final Supplier<BlueprintSchema> blueprint;

    SetBlueprintLootFunction(class_5341[] conditions, BlueprintSchema blueprint) {
        this(conditions, () -> blueprint);
    }

    SetBlueprintLootFunction(class_5341[] conditions, Supplier<BlueprintSchema> blueprint) {
        super(conditions);
        this.blueprint = blueprint;
    }

    @Override
    public class_5339 method_29321() {
        return BlueprintRegistry.BLUEPRINT_TYPE;
    }

    @Override
    public class_1799 method_522(class_1799 stack, class_47 context) {
        BlueprintItem.setSchema(stack, this.blueprint.get());
        return stack;
    }

    public static class_120.class_121<?> builder(BlueprintSchema blueprint) {
        return SetBlueprintLootFunction
                .method_520((class_5341[] conditions) -> new SetBlueprintLootFunction(conditions, blueprint));
    }

    public static class_120.class_121<?> random() {
        return SetBlueprintLootFunction
                .method_520((class_5341[] conditions) -> new SetBlueprintLootFunction(conditions, () -> BlueprintRegistry.getInstance().getRandom()));
    }

    public static class Serializer extends class_120.class_123<SetBlueprintLootFunction> {
        @Override
        public void toJson(JsonObject jsonObject, SetBlueprintLootFunction setBlueprintLootFunction,
                JsonSerializationContext jsonSerializationContext) {
            super.method_529(jsonObject, setBlueprintLootFunction, jsonSerializationContext);
            jsonObject.addProperty("id",
                    setBlueprintLootFunction.blueprint.get().id().toString());
        }

        @Override
        public SetBlueprintLootFunction method_530(JsonObject jsonObject,
                                                 JsonDeserializationContext jsonDeserializationContext, class_5341[] lootConditions) {
            String string = class_3518.method_15265(jsonObject, "id");
            BlueprintSchema blueprint = BlueprintRegistry.getInstance().getOptional(class_2960.method_12829(string))
                    .orElseThrow(() -> new JsonSyntaxException("Unknown blueprint '" + string + "'"));
            return new SetBlueprintLootFunction(lootConditions, blueprint);
        }
    }
}
