package dev.amble.ait.core.sounds.flight;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.api.Identifiable;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.core.AITSounds;

public record FlightSound(class_2960 id, class_2960 soundId, int length, String name) implements Identifiable, Nameable {

    public static final Codec<FlightSound> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    class_2960.field_25139.fieldOf("id").forGetter(FlightSound::id),
                    class_2960.field_25139.fieldOf("sound").forGetter(FlightSound::soundId),
                    Codec.INT.fieldOf("length").forGetter(FlightSound::length),
                    Codec.STRING.optionalFieldOf("name", "").forGetter(FlightSound::name)
            ).apply(instance, FlightSound::new)
    );

    public FlightSound {
        if (name.isEmpty()) {
            name = id.method_12832();
        }
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    public class_3414 sound() {
        class_3414 sfx = class_7923.field_41172.method_10223(this.soundId());

        if (sfx == null) {
            AITMod.LOGGER.error("Unknown sound event: {} in flight sfx {}", this.soundId(), this.id());
            sfx = AITSounds.ERROR;
        }

        return sfx;
    }

    public static FlightSound fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static FlightSound fromJson(JsonObject json) {
        AtomicReference<FlightSound> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(var -> created.set(var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack flight sfx: {}", err);
        });

        return created.get();
    }
}
