package dev.amble.ait.core.tardis.control;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.joml.Vector3f;
import dev.amble.ait.core.blocks.ConsoleBlock;
import dev.amble.ait.core.entities.ConsoleControlEntity;
import dev.amble.ait.data.codec.MoreCodec;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.registry.impl.ControlRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_4048;

/**
 * Holds a control which will be ran when interacted with, an
 * {@linkplain Vector3f offset} from the centre of the {@link ConsoleBlock} and
 * a {@linkplain class_4048 scale} for the entity <br>
 * <br>
 * A list of these is gotten by {@link ConsoleTypeSchema#getControlTypes()} and
 * used in {@link ConsoleControlEntity} to hold its information
 *
 * @author loqor
 * @see ConsoleControlEntity
 */
public class ControlTypes {
    public static final Codec<ControlTypes> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("id").forGetter(c -> c.getControl().id()),
            Codec.FLOAT.fieldOf("width").forGetter(c -> c.getScale().field_18067),
            Codec.FLOAT.fieldOf("height").forGetter(c -> c.getScale().field_18068),
            MoreCodec.VECTOR3F.fieldOf("offset").forGetter(ControlTypes::getOffset)
    ).apply(instance, ControlTypes::new));

    private final Control control;
    private class_4048 scale;
    private Vector3f offset;

    public ControlTypes(Control control, class_4048 scaling, Vector3f offset) {
        this.control = control;
        this.scale = scaling;
        this.offset = offset;
    }

    public ControlTypes(class_2960 controlId, float width, float height, Vector3f offset) {
        this(ControlRegistry.REGISTRY.method_10223(controlId), class_4048.method_18385(width, height), offset);
    }

    @Override
    public String toString() {
        return "ControlTypes{" + "control=" + control + ", scale=" + scale + ", offset=" + offset + '}';
    }

    public Control getControl() {
        return this.control;
    }

    public class_4048 getScale() {
        return this.scale;
    }

    public void setScale(class_4048 scale) {
        this.scale = scale;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }
}
