package dev.amble.ait.core.tardis.control.impl;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;

public class AntiGravsControl extends Control {
    public static final class_2960 ID = AITMod.id("antigravs");

    public AntiGravsControl() {
        super(ID);
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        tardis.travel().antigravs().toggle();

        CachedDirectedGlobalPos globalPos = tardis.travel().position();
        class_3218 targetWorld = globalPos.getWorld();
        class_2338 pos = globalPos.getPos();

        targetWorld.method_14178().method_14128(pos);
        world.method_39279(pos, AITBlocks.EXTERIOR_BLOCK, 2);
        return tardis.travel().antigravs().get() ? Result.SUCCESS : Result.SUCCESS_ALT;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.ANTI_GRAVS;
    }

    @Override
    protected SubSystem.IdLike requiredSubSystem() {
        return SubSystem.Id.GRAVITATIONAL;
    }
}
