package dev.amble.ait.core.tardis.control.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.lock.LockedDimensionRegistry;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.impl.pos.PosType;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;
import dev.amble.ait.core.util.WorldUtil;

public class DimensionControl extends Control {

    public static final class_2960 ID = AITMod.id("dimension");

    public DimensionControl() {
        super(ID);
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos dest = travel.destination();

        CompletableFuture<Void> future = CompletableFuture.supplyAsync(() -> {
            List<class_3218> dims = WorldUtil.getTravelWorlds();
            int index = Math.max(0, WorldUtil.travelWorldIndex(dest.getWorld()));

            if (leftClick) {
                index = (dims.size() + index - 1) % dims.size();
            } else {
                index = (index + 1) % dims.size();
            }

            return dims.get(index);
        }).thenAccept(destWorld -> {
            travel.destination(cached -> {
                CachedDirectedGlobalPos cachedPos = cached.world(destWorld);
                class_2338 clampedPos = PosType.clamp(cachedPos.getPos(), 0, destWorld);
                return cachedPos.pos(clampedPos);
            });
            messagePlayer(player, destWorld, LockedDimensionRegistry.getInstance().isUnlocked(tardis, destWorld));
        });

        AsyncLocatorUtil.LOCATING_EXECUTOR_SERVICE.submit(() -> future);
        return Result.SUCCESS;
    }

    private void messagePlayer(class_3222 player, class_3218 world, boolean unlocked) {
        class_5250 message = class_2561.method_43471("message.ait.tardis.control.dimension.info")
                .method_10852(WorldUtil.worldText(world.method_27983(), false)).method_27692(unlocked ? class_124.field_1068 : class_124.field_1080);

        if (!unlocked) message.method_10852(class_2561.method_43470(" \uD83D\uDD12"));

        player.method_7353(message, true);
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.DIMENSION;
    }
}
