package dev.amble.ait.core.tardis.control.impl;

import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;

public class ElectricalDischargeControl extends Control {

    private static final int ARTRON_COST = 1250;
    private static final int EFFECT_RADIUS = 2;
    private static final int INITIAL_DELAY = 40;
    private static final int TOTAL_DURATION = 80;

    public ElectricalDischargeControl() {
        super(AITMod.id("electrical_discharge"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        if (tardis.fuel().getCurrentFuel() < ARTRON_COST) {
            player.method_7353(class_2561.method_43469("tardis.message.control.electric.fail", ARTRON_COST).method_27692(class_124.field_1061), true);
            return Result.FAILURE;
        }

        tardis.fuel().removeFuel(ARTRON_COST);

        class_2338 exteriorPos = tardis.travel().position().getPos();
        class_3218 exteriorWorld = tardis.travel().position().getWorld();

        Scheduler.get().runTaskLater(() -> {
            spreadElectricalEffects(exteriorWorld, exteriorPos);
        }, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, INITIAL_DELAY);

        Scheduler.get().runTaskLater(() -> {
            world.method_8396(null, console, AITSounds.DING, class_3419.field_15245, 1.0F, 1.0F);
        }, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, TOTAL_DURATION);

        return Result.SUCCESS;
    }

    private void spreadElectricalEffects(class_3218 world, class_2338 pos) {
        class_238 effectBox = new class_238(pos).method_1014(EFFECT_RADIUS);

        world.method_8390(class_1309.class, effectBox, entity -> true).forEach(entity -> {
            entity.method_6092(new class_1293(class_1294.field_5909, 600, 1));
            entity.method_6092(new class_1293(class_1294.field_5899, 300, 1));
            entity.method_6092(new class_1293(class_1294.field_5903, 200, 1));
            entity.method_6092(new class_1293(class_1294.field_5911, 600, 1));
            entity.method_6092(new class_1293(class_1294.field_5901, 275, 1));
            entity.method_6092(new class_1293(class_1294.field_5916, 250, 1));
            entity.method_6092(new class_1293(class_1294.field_38092, 75, 1));
        });

        for (class_2338 targetPos : class_2338.method_10097(pos.method_10069(-EFFECT_RADIUS, -1, -EFFECT_RADIUS), pos.method_10069(EFFECT_RADIUS, 2, EFFECT_RADIUS))) {
            world.method_14199(class_2398.field_29644, targetPos.method_10263() + 0.5, targetPos.method_10264() + 1.0, targetPos.method_10260() + 0.5, 5, 0, 0.05, 0, 0.1);
        }
    }

    @Override
    protected SubSystem.IdLike requiredSubSystem() {
        return SubSystem.Id.DESPERATION;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 800;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.BWEEP;
    }
}
