package dev.amble.ait.core.tardis.control.impl;

import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;

public class FoodCreationControl extends Control {

    public FoodCreationControl() {
        super(AITMod.id("food_creation"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console,
                             boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);
        if (tardis.fuel().getCurrentFuel() < 500)
            return Result.FAILURE;

        Scheduler.get().runTaskLater(() -> {
            if (world.method_8320(console).method_26215())
                return;

            class_1799 coffeeItem = tardis.extra().getRefreshmentItem();

            class_243 spawnPosition = class_243.method_24953(console).method_1031(0, 1.5, 1);
            class_1542 coffeeEntity = new class_1542(world, spawnPosition.field_1352, spawnPosition.field_1351, spawnPosition.field_1350, coffeeItem);

            tardis.removeFuel(500);
            world.method_8649(coffeeEntity);
        }, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, 45);

        return Result.SUCCESS;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.COFFEE_MACHINE;
    }
}
