package dev.amble.ait.core.tardis.control.impl;

import java.text.DecimalFormat;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.util.WorldUtil;

public class MonitorControl extends Control {
    public MonitorControl() {
        super(AITMod.id("monitor"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        CachedDirectedGlobalPos abpd = tardis.travel().destination();
        class_2338 abpdPos = abpd.getPos();

        if (!player.method_5715()) {
            player.method_5783(class_3417.field_15015.comp_349(), 1.0F, 1.0F);

            AITMod.openScreen(player, 0, tardis.getUuid(), console);
        } else {
            DecimalFormat df = new DecimalFormat("#.##");
            String formattedNumber = df.format(tardis.getFuel());
            player.method_7353(class_2561.method_30163("X: " + abpdPos.method_10263() + " Y: " + abpdPos.method_10264() + " Z: " + abpdPos.method_10260() + " Dim: " + WorldUtil.worldText(abpd.getDimension()).getString() + " Fuel: " + formattedNumber + "/50000"), true);
        }

        return Result.SUCCESS;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.MONITOR;
    }
}
