package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class PowerControl extends Control {

    public PowerControl() {
        super(AITMod.id("power"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);
        tardis.fuel().togglePower();

        if (tardis.fuel().hasPower()) {
            int power = (int) tardis.fuel().getCurrentFuel();
            boolean inRange = power >= 1500 && power <= 2017;
            boolean doorLocked = tardis.door().locked();
            boolean refueling = !tardis.isRefueling();

            if (inRange && doorLocked && refueling) {
                TardisCriterions.ATTACK_EYEBROWS.trigger((class_3222) player);
                world.method_8396(null, console, AITSounds.MAD_MAN_MUSIC, class_3419.field_15245, 1.0f, 1.0f);
            }
        }

        return tardis.fuel().hasPower() ? Result.SUCCESS : Result.SUCCESS_ALT;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.POWER_FLICK;
    }

    @Override
    public boolean requiresPower() {
        return false;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 200;
    }

    @Override
    public boolean shouldHaveDelay(Tardis tardis) {
        return !tardis.fuel().hasPower() && super.shouldHaveDelay();
    }
}
