package dev.amble.ait.core.tardis.control.impl;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.impl.pos.IncrementManager;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelUtil;

public class RandomiserControl extends Control {

    public RandomiserControl() {
        super(AITMod.id("randomiser"));
    }

    @Override
    public Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);

        TravelHandler travel = tardis.travel();

        TravelUtil.randomPos(tardis, 10, IncrementManager.increment(tardis), cached -> {
            tardis.travel().destination(cached);
            tardis.removeFuel(0.1d * IncrementManager.increment(tardis) * tardis.travel().instability());

            messagePlayer(player, travel);
        });

        return Result.SUCCESS;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 40;
    }

    private void messagePlayer(class_3222 player, TravelHandler travel) {
        CachedDirectedGlobalPos dest = travel.destination();
        class_2338 pos = dest.getPos();

        class_2561 text = class_2561.method_43471("tardis.message.control.randomiser.destination")
                .method_10852(class_2561.method_43470(pos.method_10263() + " | " + pos.method_10264() + " | " + pos.method_10260()));

        player.method_7353(text, true);
    }
    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.RANDOMIZE;
    }
}
